/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.report.bankacct.form;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.TreeReportListEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.tmc.am.report.bankacct.helper.AcctDataListHelper;
import kd.tmc.fbp.common.enums.ReportOrgQueryWayEnum;
import kd.tmc.fbp.common.enums.RptDateRangeEnum;
import kd.tmc.fbp.common.errorcode.RptQingErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class AcctSumFormListPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private Map<String, Object> paramMap = null;
    private static Map<String, String> initStatDim = new LinkedHashMap<String, String>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void setTreeReportList(TreeReportListEvent event) {
        super.setTreeReportList(event);
        String statdim = (String)this.getModel().getValue("filter_statdim");
        event.setTreeReportList(true);
        if (Arrays.asList("company", "openorg").contains(statdim)) {
            event.setTreeExpandColId(statdim);
        } else {
            event.setTreeExpandColId("number");
        }
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
        RequestContext context = RequestContext.get();
        String appId = this.getView().getFormShowParameter().getAppId();
        BasedataEdit openorg = (BasedataEdit)this.getControl("filter_openorg");
        List orgIdList = TmcOrgDataHelper.getAuthorizedAccountLegalOrgId((Long)context.getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        openorg.setQFilter(new QFilter("id", "in", (Object)orgIdList));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "filter_statdim": {
                this.getView().refresh();
                break;
            }
            case "filter_queryway": {
                this.setOrgPropMustInput();
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setOrgPropMustInput();
    }

    private void setOrgPropMustInput() {
        boolean isMustInput = ReportOrgQueryWayEnum.ORG.getValue().equals(this.getModel().getValue("filter_queryway"));
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isMustInput, (String[])new String[]{"filter_org"});
    }

    public void beforeQuery(ReportQueryParam param) {
        String stat;
        String statdim = (String)this.getModel().getValue("filter_statdim");
        FilterItemInfo filterItem = param.getFilter().getFilterItem("statdim");
        if (filterItem == null) {
            param.getFilter().addFilterItem("statdim", (Object)statdim);
        } else {
            filterItem.setValue((Object)statdim);
        }
        String string = stat = EmptyUtil.isEmpty((Object)this.getModel().getValue("filter_stat")) ? null : this.getModel().getValue("filter_stat").toString();
        if (EmptyUtil.isNotEmpty(stat) && stat.split(",").length > 0) {
            stat = stat.trim().startsWith(",") ? stat.trim().substring(1) : stat.trim();
            stat = stat.trim().endsWith(",") ? stat.trim().substring(0, stat.trim().length() - 1) : stat.trim();
            param.getFilter().getFilterItem("filter_stat").setValue((Object)stat);
        } else {
            switch (statdim) {
                case "company": 
                case "openorg": {
                    stat = "group_acctpurpose,group_bankinterface";
                    break;
                }
                case "finorg": {
                    stat = "group_acctstyle,group_accttype,group_bankinterface";
                    break;
                }
                case "finorg_prop": {
                    stat = "group_bankinterface";
                }
            }
            param.getFilter().getFilterItem("filter_stat").setValue((Object)stat);
        }
        this.initQueryColumn(statdim, param);
        super.beforeQuery(param);
    }

    public boolean verifyQuery(ReportQueryParam param) {
        Map<String, Object> paramMap = this.getParamMap(param);
        RptQingErrorCode rptQingErrorCode = new RptQingErrorCode();
        String queryType = (String)paramMap.get("filter_queryway");
        if ("org".equals(queryType) && paramMap.get("filter_company_id") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7\uff08\u7533\u8bf7\u516c\u53f8\uff09\u5fc5\u5f55\u3002", (String)"RestrictedFundsFormListPlugin_15", (String)"tmc-am-report", (Object[])new Object[0]));
            return false;
        }
        String key = null;
        Object value = null;
        for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            if (!key.endsWith("ranges") || !RptDateRangeEnum.CUSTOM.getValue().equals(value)) continue;
            if (EmptyUtil.isEmpty((Object)paramMap.get(key + "_startdate")) || EmptyUtil.isEmpty((Object)paramMap.get(key + "_enddate"))) {
                throw new TmcBizException(rptQingErrorCode.DEFINEDATE_NULL());
            }
            if (!((Date)paramMap.get(key + "_startdate")).after((Date)paramMap.get(key + "_enddate"))) continue;
            throw new TmcBizException(rptQingErrorCode.BEGINDATE_AFTER());
        }
        return true;
    }

    private void initQueryColumn(String statdim, ReportQueryParam param) {
        String fieldStr;
        Map<String, Object> paramMap = this.getParamMap(param);
        String stat = (String)paramMap.get("filter_stat");
        StringBuilder fields = new StringBuilder();
        switch (statdim) {
            case "company": {
                this.visableListColumn("company,bank_cate,stat," + stat);
                fields.append(",");
                fields.append(ResManager.loadKDString((String)"\u7533\u8bf7\u516c\u53f8,\u91d1\u878d\u673a\u6784,\u7533\u8bf7\u516c\u53f8ID", (String)"AcctSumFormListPlugin_11", (String)"tmc-am-report", (Object[])new Object[0]));
                break;
            }
            case "openorg": {
                this.visableListColumn("openorg,bank_cate,stat," + stat);
                fields.append(",");
                fields.append(ResManager.loadKDString((String)"\u5f00\u6237\u516c\u53f8,\u91d1\u878d\u673a\u6784,\u5f00\u6237\u516c\u53f8ID", (String)"AcctSumFormListPlugin_14", (String)"tmc-am-report", (Object[])new Object[0]));
                break;
            }
            case "finorg": {
                this.visableListColumn("finorginfo,bank_cate,stat," + stat);
                fields.append(",");
                fields.append(ResManager.loadKDString((String)"\u91d1\u878d\u673a\u6784,\u5f00\u6237\u884c,\u91d1\u878d\u673a\u6784\u7c7b\u522b", (String)"AcctSumFormListPlugin_12", (String)"tmc-am-report", (Object[])new Object[0]));
                break;
            }
            case "finorg_prop": {
                this.visableListColumn("bank_cate,country,province,city,stat," + stat);
                fields.append(",");
                fields.append(ResManager.loadKDString((String)"\u56fd\u5bb6\u6216\u5730\u533a,\u7701\u4efd,\u57ce\u5e02,\u91d1\u878d\u673a\u6784", (String)"AcctSumFormListPlugin_18", (String)"tmc-am-report", (Object[])new Object[0]));
            }
        }
        fields.append(",");
        fields.append(ResManager.loadKDString((String)"\u6c47\u603b,\u91d1\u878d\u673a\u6784\u7c7b\u522b,\u6392\u5e8f", (String)"AcctSumFormListPlugin_21", (String)"tmc-am-report", (Object[])new Object[0]));
        if (EmptyUtil.isNoEmpty((String)stat)) {
            List<String> lst = Arrays.asList(stat.split(","));
            for (Map.Entry<String, String> entry : initStatDim.entrySet()) {
                if (!lst.contains(entry.getKey())) continue;
                fields.append(",").append(entry.getValue());
            }
        }
        if (statdim.equals("finorg_prop")) {
            fields.append(",");
            fields.append(ResManager.loadKDString((String)"\u57ce\u5e02ID", (String)"AcctSumFormListPlugin_23", (String)"tmc-am-report", (Object[])new Object[0]));
        }
        if (EmptyUtil.isNoEmpty((String)(fieldStr = fields.toString()))) {
            this.rebuildColumn(fieldStr.split(","));
        }
    }

    private void visableListColumn(String fields) {
        ReportList listTable = (ReportList)this.getView().getControl("reportlistap");
        for (AbstractReportColumn column : listTable.getColumns()) {
            if (column instanceof ReportColumn) {
                if (fields.indexOf(((ReportColumn)column).getFieldKey()) >= 0) {
                    ((ReportColumn)column).setHide(false);
                    continue;
                }
                ((ReportColumn)column).setHide(true);
                continue;
            }
            if (!(column instanceof ReportColumnGroup)) continue;
            for (AbstractReportColumn child : ((ReportColumnGroup)column).getChildren()) {
                if (fields.indexOf(((ReportColumn)child).getFieldKey()) >= 0) {
                    ((ReportColumn)child).setHide(false);
                    continue;
                }
                ((ReportColumn)child).setHide(true);
            }
        }
    }

    private void rebuildColumn(String[] feilds) {
        ReportList listTable = (ReportList)this.getView().getControl("reportlistap");
        AcctDataListHelper.rebuildColumn(feilds, listTable);
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        if ("stat".equals(event.getFieldName())) {
            int rowIndex = event.getRowIndex();
            ReportList rptList = (ReportList)event.getSource();
            DynamicObject row = rptList.getReportModel().getRowData(rowIndex);
            ReportQueryParam queryParam = this.getQueryParam();
            FilterInfo filter = queryParam.getFilter();
            HashMap<String, QFilter> commFilters = new HashMap<String, QFilter>();
            String statdim = (String)this.getModel().getValue("filter_statdim");
            String sumlevel = row.getString("sumlevel");
            switch (statdim) {
                case "company": {
                    if (sumlevel.equals("2")) break;
                    if (sumlevel.equals("1")) {
                        row = rptList.getReportModel().getRowData(rowIndex - 1);
                    } else {
                        commFilters.putAll(this.getBankCateQfilter(row));
                    }
                    commFilters.put("filter_org", new QFilter("company.id", "in", (Object)new Long[]{Long.valueOf(row.get("companyid").toString())}));
                    break;
                }
                case "openorg": {
                    if (sumlevel.equals("2")) break;
                    if (sumlevel.equals("1")) {
                        row = rptList.getReportModel().getRowData(rowIndex - 1);
                    } else {
                        commFilters.putAll(this.getBankCateQfilter(row));
                    }
                    commFilters.put("filter_openorg", new QFilter("openorg.id", "in", (Object)new Long[]{Long.valueOf(row.get("openorgid").toString())}));
                    break;
                }
                case "finorg": {
                    if (sumlevel.equals("2")) break;
                    if (sumlevel.equals("1")) {
                        row = rptList.getReportModel().getRowData(rowIndex - 1);
                    } else if (StringUtils.isBlank((Object)row.get("finorginfo"))) {
                        commFilters.put("bank.name", QFilter.isNull((String)"bank.name"));
                    } else {
                        commFilters.put("bank.name", new QFilter("bank.name", "in", (Object)new Object[]{row.get("finorginfo")}));
                    }
                    commFilters.putAll(this.getBankCateQfilter(row));
                    break;
                }
                case "finorg_prop": {
                    if (sumlevel.equals("2")) break;
                    if (sumlevel.equals("1")) {
                        row = rptList.getReportModel().getRowData(rowIndex - 1);
                    } else {
                        if (StringUtils.isBlank((Object)row.get("city"))) {
                            commFilters.put("bank.city", QFilter.isNull((String)"bank.city.name"));
                        } else {
                            commFilters.put("bank.city", new QFilter("bank.city.name", "=", row.get("city")));
                        }
                        commFilters.putAll(this.getBankCateQfilter(row));
                    }
                    if (StringUtils.isBlank((Object)row.get("country"))) {
                        commFilters.put("bank.country", QFilter.isNull((String)"bank.country.name"));
                    } else {
                        commFilters.put("bank.country", new QFilter("bank.country.name", "=", row.get("country")));
                    }
                    if (StringUtils.isBlank((Object)row.get("province"))) {
                        commFilters.put("bank.province", QFilter.isNull((String)"bank.province.name"));
                        break;
                    }
                    commFilters.put("bank.province", new QFilter("bank.province.name", "=", row.get("province")));
                }
            }
            ReportShowParameter param = new ReportShowParameter();
            param.getCustomParams().put("statdim", statdim);
            param.getCustomParams().put("filter", SerializationUtils.serializeToBase64((Object)filter));
            param.getCustomParams().put("commFilters", SerializationUtils.serializeToBase64(commFilters));
            param.setFormId("am_acctdetlrpt");
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)param);
        }
    }

    private String defaultIfNull(String object, String defaultValue) {
        return !EmptyUtil.isEmpty((String)object) ? object : defaultValue;
    }

    private Map<String, QFilter> getBankCateQfilter(DynamicObject row) {
        HashMap<String, QFilter> map = new HashMap<String, QFilter>();
        String finOrgType = row.getString("finorgtype");
        String bankcate = row.getString("bank_cate");
        if ("0".equals(finOrgType)) {
            QFilter bankQFilter = new QFilter("bank.bank_cate.name", "=", (Object)bankcate);
            if (StringUtils.isBlank((CharSequence)bankcate)) {
                bankQFilter.or(QFilter.isNull((String)"bank.bank_cate.name"));
            }
            map.put("bank.bank_cate.name", bankQFilter);
            map.put("finorgtype", new QFilter("finorgtype", "=", (Object)finOrgType));
        } else if (!"-1".equals(finOrgType)) {
            QFilter bankQFilter = new QFilter("bank.name", "=", (Object)bankcate);
            if (StringUtils.isBlank((CharSequence)bankcate)) {
                bankQFilter.or(QFilter.isNull((String)"bank.name"));
            }
            map.put("bank.name", bankQFilter);
            map.put("finorgtype", new QFilter("finorgtype", "=", (Object)finOrgType));
        }
        return map;
    }

    private Map<String, Object> getParamMap(ReportQueryParam param) {
        if (this.paramMap == null) {
            this.paramMap = AcctDataListHelper.transQueryParam(param);
        }
        return this.paramMap;
    }

    static {
        initStatDim.put("group_acctpurpose", ResManager.loadKDString((String)"\u8d26\u6237\u7528\u9014", (String)"AcctSumFormListPlugin_0", (String)"tmc-am-report", (Object[])new Object[0]));
        initStatDim.put("group_acctstyle", ResManager.loadKDString((String)"\u8d26\u6237\u7c7b\u578b", (String)"AcctSumFormListPlugin_1", (String)"tmc-am-report", (Object[])new Object[0]));
        initStatDim.put("group_accttype", ResManager.loadKDString((String)"\u8d26\u6237\u6027\u8d28", (String)"AcctSumFormListPlugin_2", (String)"tmc-am-report", (Object[])new Object[0]));
        initStatDim.put("group_bankinterface", ResManager.loadKDString((String)"\u94f6\u4f01\u63a5\u53e3", (String)"AcctSumFormListPlugin_3", (String)"tmc-am-report", (Object[])new Object[0]));
    }
}

