/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.report.bankacct.form;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.am.report.bankacct.helper.AcctDataListHelper;
import kd.tmc.am.report.bankacct.helper.DormantSettingFilterHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DormantFormListPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(DormantFormListPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.defaultOrg();
    }

    public void initialize() {
        super.initialize();
        this.addListener();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String queryWay = (String)this.getModel().getValue("filter_queryway");
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)"org".equals(queryWay), (String[])new String[]{"filter_org"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("filter_queryway".equals(name)) {
            String queryWay = (String)this.getModel().getValue("filter_queryway");
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)"org".equals(queryWay), (String[])new String[]{"filter_org"});
        }
    }

    private void defaultOrg() {
        Long org = RequestContext.get().getOrgId();
        String appId = this.getView().getFormShowParameter().getAppId();
        List authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        this.getModel().setValue("filter_org", null);
        if (authOrgIds != null && authOrgIds.size() > 0) {
            if (authOrgIds.contains(org)) {
                DynamicObject dynamicObjects = BusinessDataServiceHelper.loadSingle((Object)org, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_org"));
                DynamicObjectCollection dynamicObjects1 = new DynamicObjectCollection();
                dynamicObjects1.add((Object)dynamicObjects);
                this.getModel().setValue("filter_org", (Object)dynamicObjects1);
            } else {
                DynamicObject dynamicObjects = BusinessDataServiceHelper.loadSingle(authOrgIds.get(0), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_org"));
                if (EmptyUtil.isNoEmpty((DynamicObject)dynamicObjects)) {
                    DynamicObjectCollection dynamicObjects1 = new DynamicObjectCollection();
                    dynamicObjects1.add((Object)dynamicObjects);
                    this.getModel().setValue("filter_org", (Object)dynamicObjects1);
                }
            }
        }
    }

    public void addListener() {
        BasedataEdit filterCompany = (BasedataEdit)this.getControl("filter_org");
        filterCompany.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            String appId = this.getView().getFormShowParameter().getAppId();
            List authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
            param.setCustomParam("range", (Object)authOrgIds);
        });
        BasedataEdit filterOpenorg = (BasedataEdit)this.getControl("filter_openorg");
        filterOpenorg.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            String appId = this.getView().getFormShowParameter().getAppId();
            List authOrgIds = TmcOrgDataHelper.getAuthorizedAccountLegalOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
            param.setCustomParam("range", (Object)authOrgIds);
        });
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        int rowIndex = event.getRowIndex();
        ReportList reportList = (ReportList)event.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        BaseShowParameter showParameter = new BaseShowParameter();
        ReportQueryParam queryParam = this.getQueryParam();
        String datafrom = (String)queryParam.getFilter().getFilterItem("datafrom").getValue();
        String bankacctnumber = rowData.getString("bankaccountnumber_list");
        DynamicObject bankAcct = TmcDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id,finorgtype,issetbankinterface", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)bankacctnumber)});
        if ("bankaccountnumber_list".equals(event.getFieldName())) {
            if (EmptyUtil.isNoEmpty((DynamicObject)bankAcct)) {
                Object pkValue = bankAcct.getPkValue();
                showParameter.setPkId(pkValue);
                showParameter.setFormId("bd_accountbanks");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)showParameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"DormantFormListPlugin_0", (String)"tmc-am-report", (Object[])new Object[0]));
            }
        }
        if ("tradecount_list".equals(event.getFieldName())) {
            boolean isBankjournal = true;
            switch (datafrom) {
                case "bankjournal": {
                    if (EmptyUtil.isNoEmpty((DynamicObject)bankAcct)) {
                        this.setShowParameter(bankacctnumber, isBankjournal);
                        break;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"DormantFormListPlugin_0", (String)"tmc-am-report", (Object[])new Object[0]));
                    break;
                }
                case "transdetail": {
                    isBankjournal = false;
                    if (EmptyUtil.isNoEmpty((DynamicObject)bankAcct)) {
                        this.setShowParameter(bankacctnumber, isBankjournal);
                        break;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"DormantFormListPlugin_0", (String)"tmc-am-report", (Object[])new Object[0]));
                    break;
                }
                case "other": {
                    if (EmptyUtil.isNoEmpty((DynamicObject)bankAcct)) {
                        if ("1".equals(bankAcct.getString("finorgtype")) || "3".equals(bankAcct.getString("finorgtype")) || bankAcct.getBoolean("issetbankinterface")) {
                            isBankjournal = false;
                            this.setShowParameter(bankacctnumber, isBankjournal);
                            break;
                        }
                        this.setShowParameter(bankacctnumber, isBankjournal);
                        break;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"DormantFormListPlugin_0", (String)"tmc-am-report", (Object[])new Object[0]));
                }
            }
        }
    }

    private void setShowParameter(String bankacctnumber, boolean bool) {
        Map<String, Object> settingFilterMap = DormantSettingFilterHelper.dormantSettingFilter();
        ListShowParameter param = new ListShowParameter();
        if (bool) {
            param.setBillFormId("cas_bankjournal");
        } else {
            param.setBillFormId("bei_transdetail");
        }
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.getOpenStyle().setInlineStyleCss(null);
        param.setFormId("bos_list");
        QFilter filter = new QFilter("accountbank.bankaccountnumber", "=", (Object)bankacctnumber).and(new QFilter("bizdate", ">=", settingFilterMap.get("queryStartDate"))).and(new QFilter("bizdate", "<=", settingFilterMap.get("queryEndDate")));
        param.getListFilterParameter().setFilter(filter);
        logger.info("==================================filter= " + filter);
        this.getView().showForm((FormShowParameter)param);
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
        RequestContext context = RequestContext.get();
        String appId = this.getView().getFormShowParameter().getAppId();
        BasedataEdit openorg = (BasedataEdit)this.getControl("filter_openorg");
        List orgIdList = TmcOrgDataHelper.getAuthorizedAccountLegalOrgId((Long)context.getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        openorg.setQFilter(new QFilter("id", "in", (Object)orgIdList));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        if ("setting".equalsIgnoreCase(op.getOperateKey())) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("am_dormantsetting");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(parameter);
        }
        if ("qing".equalsIgnoreCase(op.getOperateKey())) {
            ReportShowParameter reportShowParameter = new ReportShowParameter();
            reportShowParameter.setFormId("am_qing_dormantrpt");
            reportShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)reportShowParameter);
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        MulBasedataDynamicObjectCollection companys = (MulBasedataDynamicObjectCollection)this.getModel().getValue("filter_org");
        List orgList = companys.stream().map(d -> d.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
        Map<String, Object> paramMap = AcctDataListHelper.transQueryParam(queryParam);
        String queryType = (String)paramMap.get("filter_queryway");
        if ("org".equals(queryType) && orgList.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7\uff08\u7533\u8bf7\u516c\u53f8\uff09\u5fc5\u5f55\u3002", (String)"RestrictedFundsFormListPlugin_15", (String)"tmc-am-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

