/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.report.bankacct.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.events.TreeReportListEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.am.common.helper.AccountBankHelper;
import kd.tmc.am.common.helper.OrgHelper;
import kd.tmc.am.common.helper.PeriodHelper;
import kd.tmc.am.report.bankacct.helper.AcctDataListHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.VisibleVirtualAcctHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RestrictedFundsFormListPlugin
extends AbstractReportFormPlugin {
    public void afterCreateNewData(EventObject e) {
        DynamicObjectCollection queryFisBankRollOrg;
        super.afterCreateNewData(e);
        this.initCurrencyAndRate();
        long orgId = RequestContext.get().getOrgId();
        String appId = this.getView().getFormShowParameter().getAppId();
        Long fisBankRollOrg = OrgHelper.getFisBankRollOrg((Long)orgId, (String)appId, (Long)RequestContext.get().getCurrUserId(), (String)"47150e89000000ac", (String)"am_restrictedfundsrpt");
        if (fisBankRollOrg != null && !(queryFisBankRollOrg = QueryServiceHelper.query((String)"am_restrictedfundsrpt", (String)"cas_cashmgtinit", (String)"org as id", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)new Long[]{fisBankRollOrg}), new QFilter("isfinishinit", "=", (Object)"1")}, null)).isEmpty()) {
            DynamicObject initObj = PeriodHelper.getCasInitInfo((long)fisBankRollOrg);
            this.getModel().setValue("filter_exratetable", initObj.getDynamicObject("exratetable").getPkValue());
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String queryWay = (String)this.getModel().getValue("filter_queryway");
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)"org".equals(queryWay), (String[])new String[]{"filter_org"});
    }

    private void initCurrencyAndRate() {
        DynamicObjectCollection coll;
        MulBasedataDynamicObjectCollection companyList = (MulBasedataDynamicObjectCollection)this.getModel().getValue("filter_org");
        List orgList = companyList.stream().map(d -> d.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
        if (!orgList.isEmpty() && (coll = QueryServiceHelper.query((String)"queryCashInit", (String)"cas_cashmgtinit", (String)"exratetable,standardcurrency", (QFilter[])new QFilter[]{new QFilter("org", "in", orgList)}, null)) != null && !coll.isEmpty()) {
            this.getModel().setValue("filter_statcurrency", (Object)((DynamicObject)coll.get(0)).getLong("standardcurrency"));
            this.getModel().setValue("filter_exratetable", (Object)((DynamicObject)coll.get(0)).getLong("exratetable"));
        }
    }

    public void initialize() {
        super.initialize();
        this.addListener();
    }

    public void setTreeReportList(TreeReportListEvent event) {
        super.setTreeReportList(event);
        event.setTreeReportList(true);
        event.setTreeExpandColId("orgname");
    }

    public void addListener() {
        BasedataEdit bankNum = (BasedataEdit)this.getControl("filter_mulbankacct");
        bankNum.addBeforeF7SelectListener(evt -> {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            List<Object> orgIdList = new ArrayList();
            orgIdList = this.getAllOrgId();
            List acctList = AccountBankHelper.getAcctBankByOrg(orgIdList);
            if (acctList != null && acctList.size() > 0) {
                QFilter qFilter = new QFilter("id", "in", (Object)acctList);
                showParameter.getListFilterParameter().setFilter(qFilter);
            } else {
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "=", null));
            }
        });
    }

    protected QFilter[] getAcctFilter(List<Long> orgPks) {
        QFilter[] accountFilter = new QFilter[]{AccountBankHelper.getAccountBankFilterByOrg(orgPks)};
        ArrayList<QFilter> qFilterArrayList = new ArrayList<QFilter>(2);
        Collections.addAll(qFilterArrayList, accountFilter);
        qFilterArrayList.add(VisibleVirtualAcctHelper.notVirtualAcctQf());
        accountFilter = qFilterArrayList.toArray(new QFilter[qFilterArrayList.size()]);
        return accountFilter;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
    }

    private List<Long> getAllOrgId() {
        String queryType = this.getModel().getValue("filter_queryway").toString();
        List<Long> orgIdList = new ArrayList<Long>();
        if (!queryType.isEmpty() && queryType.equalsIgnoreCase("org")) {
            DynamicObjectCollection orgColl = (DynamicObjectCollection)this.getModel().getValue("filter_org");
            if (orgColl.size() > 0) {
                for (DynamicObject data : orgColl) {
                    DynamicObject obj = data.getDynamicObject("fbasedataid");
                    if (EmptyUtil.isEmpty((DynamicObject)obj)) continue;
                    orgIdList.add(Long.parseLong(obj.getPkValue().toString()));
                }
            } else {
                String appId = this.getView().getFormShowParameter().getAppId();
                orgIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
            }
        } else if (!queryType.isEmpty() && queryType.equalsIgnoreCase("orgview")) {
            DynamicObject companyView = (DynamicObject)this.getModel().getValue("filter_orgview");
            String companyViewNum = companyView.getString("number");
            orgIdList = OrgUnitServiceHelper.getAllOrg((String)companyViewNum);
        }
        return orgIdList;
    }

    public boolean verifyQuery(ReportQueryParam param) {
        boolean isChecked;
        if (param != null && !(isChecked = this.checkMustInput(param))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u5f55\u3002", (String)"RestrictedFundsFormListPlugin_14", (String)"tmc-am-report", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"filter_statcurrency");
    }

    private boolean checkMustInput(ReportQueryParam param) {
        DynamicObject compview;
        Map<String, Object> paramMap = AcctDataListHelper.transQueryParam(param);
        Date restrictedDate = (Date)paramMap.get("filter_date");
        if (restrictedDate == null) {
            return Boolean.FALSE;
        }
        DynamicObject exrateTable = (DynamicObject)paramMap.get("filter_exratetable");
        if (exrateTable == null) {
            return Boolean.FALSE;
        }
        Object queryType = paramMap.get("filter_queryway");
        if (queryType != null && ("orgview".equalsIgnoreCase(queryType.toString()) ? (compview = (DynamicObject)paramMap.get("filter_orgview")) == null : "org".equalsIgnoreCase(queryType.toString()) && EmptyUtil.isEmpty((Collection)(compview = (List)paramMap.get("filter_company_id"))))) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
        RequestContext context = RequestContext.get();
        BasedataEdit company = (BasedataEdit)this.getControl("filter_org");
        String appId = this.getView().getFormShowParameter().getAppId();
        List comIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)context.getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        company.setQFilter(new QFilter("id", "in", (Object)comIdList));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("filter_queryway".equals(name)) {
            String queryWay = (String)this.getModel().getValue("filter_queryway");
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)"org".equals(queryWay), (String[])new String[]{"filter_org"});
        }
    }
}

