/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.report.bankacct.form;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TmcAcctFormListPlugin
extends AbstractReportFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.defaultOrg();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"opendefinedate", "closedefinedate"});
    }

    public void initialize() {
        super.initialize();
        this.addListener();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String pageId = this.getView().getPageId();
        if (pageId.contains("fromacct")) {
            IReportView view = this.getView();
            ReportShowParameter parameter = (ReportShowParameter)view.getFormShowParameter();
            FilterInfo filterInfo = parameter.getReportQueryParam().getFilter();
            String companyIdStr = filterInfo.getString("filter_company_id");
            Object[] ids = (Long[])Arrays.stream(companyIdStr.replace("[", "").replace("]", "").split(",")).map(i -> Long.valueOf(i.trim())).toArray(Long[]::new);
            DynamicObject[] companys = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_org"));
            DynamicObjectCollection companyColl = new DynamicObjectCollection();
            for (DynamicObject company : companys) {
                companyColl.add((Object)company);
            }
            this.getModel().setValue("filter_org", (Object)companyColl);
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        MulBasedataDynamicObjectCollection companys = (MulBasedataDynamicObjectCollection)this.getModel().getValue("filter_org");
        List orgList = companys.stream().map(d -> d.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
        if (orgList.size() != 0) {
            queryParam.getFilter().addFilterItem("filter_company_id", orgList);
            queryParam.getFilter().getFilterItem("filter_org").setValue(null);
        }
        return true;
    }

    private void defaultOrg() {
        Long org = RequestContext.get().getOrgId();
        String appId = this.getView().getFormShowParameter().getAppId();
        List authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        this.getModel().setValue("filter_company", null);
        if (authOrgIds != null && authOrgIds.size() > 0) {
            if (authOrgIds.contains(org)) {
                DynamicObject bosOrg = BusinessDataServiceHelper.loadSingle((Object)org, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_org"));
                DynamicObjectCollection collection = new DynamicObjectCollection();
                collection.add((Object)bosOrg);
                this.getModel().setValue("filter_org", (Object)collection);
            } else {
                DynamicObject bosOrg = BusinessDataServiceHelper.loadSingle(authOrgIds.get(0), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_org"));
                if (EmptyUtil.isNoEmpty((DynamicObject)bosOrg)) {
                    DynamicObjectCollection collection = new DynamicObjectCollection();
                    collection.add((Object)bosOrg);
                    this.getModel().setValue("filter_org", (Object)collection);
                }
            }
        }
    }

    public void addListener() {
        BasedataEdit filterCompany = (BasedataEdit)this.getControl("filter_org");
        filterCompany.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            String appId = this.getView().getFormShowParameter().getAppId();
            List authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
            param.setCustomParam("range", (Object)authOrgIds);
        });
        BasedataEdit filterOpenorg = (BasedataEdit)this.getControl("filter_openorg");
        filterOpenorg.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            String appId = this.getView().getFormShowParameter().getAppId();
            List authOrgIds = TmcOrgDataHelper.getAuthorizedAccountLegalOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
            param.setCustomParam("range", (Object)authOrgIds);
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valSet = e.getChangeSet();
        Object propValue = valSet[0].getNewValue();
        boolean isCustom = EmptyUtil.isEmpty((Object)propValue) ? false : "custom".equals(propValue.toString());
        switch (propName) {
            case "opendateranges": {
                this.getView().setVisible(Boolean.valueOf(isCustom), new String[]{"opendefinedate"});
                if (isCustom) break;
                this.getModel().setValue("opendateranges_startdate", null);
                this.getModel().setValue("opendateranges_enddate", null);
                break;
            }
            case "closedateranges": {
                this.getView().setVisible(Boolean.valueOf(isCustom), new String[]{"closedefinedate"});
                if (isCustom) break;
                this.getModel().setValue("closedateranges_startdate", null);
                this.getModel().setValue("closedateranges_enddate", null);
                break;
            }
            case "filter_statdim": {
                ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
                if (EmptyUtil.isEmpty((Object)rptFilter)) break;
                rptFilter.search();
                break;
            }
        }
    }
}

