/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.report.bankacct.helper;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.RptDateRangeEnum;
import kd.tmc.fbp.common.util.DateUtils;

public class DormantSettingFilterHelper {
    public static final String FTRADECOUNT_MAP = "FTRADECOUNT_MAP";
    public static final String FDATARANGE_MAP = "FDATARANGE_MAP";

    public static Map<String, Object> dormantSettingFilter() {
        HashMap<String, Object> settingFilterMap = new HashMap<String, Object>();
        int tradenumber = 5;
        String datarange = "sixmonth";
        try (TXHandle txHandle = TX.requiresNew();){
            String selectStr = "SELECT FTRADECOUNT,FDATARANGE FROM T_AM_DORMANTSET";
            Map info = (Map)DB.query((DBRoute)DBRouteConst.SYS, (String)selectStr, (Object[])new Object[0], rs -> {
                HashMap<String, String> lockInfo = new HashMap<String, String>();
                if (rs.next()) {
                    lockInfo.put(FTRADECOUNT_MAP, rs.getString(1));
                    lockInfo.put(FDATARANGE_MAP, rs.getString(2));
                }
                return lockInfo;
            });
            if (info.size() != 0) {
                tradenumber = Integer.parseInt((String)info.get(FTRADECOUNT_MAP));
                datarange = (String)info.get(FDATARANGE_MAP);
            }
        }
        Date queryStartDate = new Date();
        Date queryEndDate = new Date();
        if (datarange.contains(RptDateRangeEnum.CUSTOM.getValue())) {
            String[] data = datarange.split("&");
            if (data.length == 3) {
                queryStartDate = new Date(Long.parseLong(data[1]));
                queryEndDate = new Date(Long.parseLong(data[2]));
            }
        } else {
            queryStartDate = DormantSettingFilterHelper.transRange2Date(datarange);
            queryEndDate = DateUtils.getNextDay((Date)DateUtils.getCurrentDate(), (int)1);
        }
        settingFilterMap.put("queryStartDate", queryStartDate);
        settingFilterMap.put("queryEndDate", queryEndDate);
        settingFilterMap.put("tradenumber", tradenumber);
        return settingFilterMap;
    }

    public static Date transRange2Date(String datarange) {
        Date endDate = DateUtils.getNextDay((Date)DateUtils.getCurrentDate(), (int)1);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(endDate);
        if (RptDateRangeEnum.ONEMONTH.getValue().equals(datarange)) {
            calendar.add(2, -1);
        } else if (RptDateRangeEnum.THREEMONTH.getValue().equals(datarange)) {
            calendar.add(2, -3);
        } else if (RptDateRangeEnum.SIXMONTH.getValue().equals(datarange)) {
            calendar.add(2, -6);
        } else if (RptDateRangeEnum.NIGHTMONTH.getValue().equals(datarange)) {
            calendar.add(2, -9);
        } else if (RptDateRangeEnum.ONEYEAR.getValue().equals(datarange)) {
            calendar.add(1, -1);
        } else if (RptDateRangeEnum.TWOYEAR.getValue().equals(datarange)) {
            calendar.add(1, -2);
        } else if (RptDateRangeEnum.THREEYEAR.getValue().equals(datarange)) {
            calendar.add(1, -3);
        }
        Date beginDate = DateUtils.getDataFormat((Date)calendar.getTime(), (boolean)true);
        return beginDate;
    }
}

