/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.report.bankacct.qing.data;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.am.report.bankacct.helper.QingRptFilterParamHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.qing.data.AbstractQingAnlsDataPlugin;

public class AcctChangeSumQingAnlsPlugin
extends AbstractQingAnlsDataPlugin {
    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{"company.name", ResManager.loadKDString((String)"\u7533\u8bf7\u516c\u53f8", (String)"AcctChangeSumQingAnlsPlugin_0", (String)"tmc-am-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), Boolean.FALSE});
        field.add(new Object[]{"openorg.name", ResManager.loadKDString((String)"\u5f00\u6237\u516c\u53f8", (String)"AcctChangeSumQingAnlsPlugin_1", (String)"tmc-am-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), Boolean.FALSE});
        field.add(new Object[]{"acctproperty.name", ResManager.loadKDString((String)"\u8d26\u6237\u7528\u9014", (String)"AcctChangeSumQingAnlsPlugin_2", (String)"tmc-am-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), Boolean.FALSE});
        field.add(new Object[]{"beginQty", ResManager.loadKDString((String)"\u671f\u521d\u8d26\u6237\u6570", (String)"AcctChangeSumQingAnlsPlugin_3", (String)"tmc-am-report", (Object[])new Object[0]), QingFieldType.Int.toNumber(), Boolean.FALSE});
        field.add(new Object[]{"addQty", ResManager.loadKDString((String)"\u672c\u671f\u5f00\u6237\u6570", (String)"AcctChangeSumQingAnlsPlugin_4", (String)"tmc-am-report", (Object[])new Object[0]), QingFieldType.Int.toNumber(), Boolean.FALSE});
        field.add(new Object[]{"closeQty", ResManager.loadKDString((String)"\u672c\u671f\u9500\u6237\u6570", (String)"AcctChangeSumQingAnlsPlugin_5", (String)"tmc-am-report", (Object[])new Object[0]), QingFieldType.Int.toNumber(), Boolean.FALSE});
        field.add(new Object[]{"endQty", ResManager.loadKDString((String)"\u671f\u672b\u8d26\u6237\u6570", (String)"AcctChangeSumQingAnlsPlugin_6", (String)"tmc-am-report", (Object[])new Object[0]), QingFieldType.Int.toNumber(), Boolean.FALSE});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        Date startdate = DateUtils.stringToDate((String)((String)paramMap.get("dateranges_startdate")), (String)"yyyy-MM-dd");
        Date endDate = DateUtils.stringToDate((String)((String)paramMap.get("dateranges_enddate")), (String)"yyyy-MM-dd");
        boolean isincludefinorg = (Boolean)paramMap.get("isincludefinorg");
        QFilter orgfilter = QingRptFilterParamHelper.initOrgFilter(paramMap);
        QFilter filter = null;
        if (!isincludefinorg) {
            filter = new QFilter("bank.finorgtype.type", "=", (Object)"0");
        }
        ArrayList<Long> bankIds = new ArrayList<Long>();
        if (!isincludefinorg && !EmptyUtil.isEmpty((Object)paramMap.get("banktype"))) {
            for (Object bank : (JSONArray)paramMap.get("banktype")) {
                bankIds.add(((JSONObject)bank).getLong("id"));
            }
        }
        if (bankIds.size() > 0 && null != filter) {
            filter.and(new QFilter("bank.bank_cate.id", "in", bankIds));
        }
        ArrayList<Long> finorgIds = new ArrayList<Long>();
        if (!isincludefinorg && !EmptyUtil.isEmpty((Object)paramMap.get("finorginfo"))) {
            for (Object finorginfo : (JSONArray)paramMap.get("finorginfo")) {
                finorgIds.add(((JSONObject)finorginfo).getLong("id"));
            }
        }
        if (bankIds.size() > 0 && null != filter) {
            filter.and(new QFilter("bank.id", "in", finorgIds));
        }
        if (orgfilter != null) {
            if (filter != null) {
                filter.and(orgfilter);
            } else {
                filter = orgfilter;
            }
        }
        QFilter f1 = new QFilter("closedate", ">", (Object)startdate);
        f1.or(QFilter.isNull((String)"closedate"));
        QFilter[] beginFilter = new QFilter[]{f1, new QFilter("opendate", "<", (Object)startdate)};
        if (filter != null) {
            beginFilter = new QFilter[]{filter, f1, new QFilter("opendate", "<", (Object)startdate)};
        }
        DataSet beginDs = QueryServiceHelper.queryDataSet((String)"BankAcctChange", (String)"bd_accountbanks", (String)"company.name, openorg.name, acctproperty.name, 1 beginQty, 0 addQty, 0 closeQty", (QFilter[])beginFilter, null);
        QFilter[] addFilter = new QFilter[]{new QFilter("opendate", ">=", (Object)startdate), new QFilter("opendate", "<=", (Object)endDate)};
        if (filter != null) {
            addFilter = new QFilter[]{filter, new QFilter("opendate", ">=", (Object)startdate), new QFilter("opendate", "<=", (Object)endDate)};
        }
        DataSet addDs = QueryServiceHelper.queryDataSet((String)"BankAcctChange", (String)"bd_accountbanks", (String)"company.name, openorg.name, acctproperty.name, 0 beginQty, 1 addQty, 0 closeQty", (QFilter[])addFilter, null);
        QFilter[] closeFilter = new QFilter[]{new QFilter("closedate", ">=", (Object)startdate), new QFilter("closedate", "<=", (Object)endDate)};
        if (filter != null) {
            closeFilter = new QFilter[]{filter, new QFilter("closedate", ">=", (Object)startdate), new QFilter("closedate", "<=", (Object)endDate)};
        }
        DataSet closeDs = QueryServiceHelper.queryDataSet((String)"BankAcctChange", (String)"bd_accountbanks", (String)"company.name, openorg.name,  acctproperty.name, 0 beginQty, 0 addQty, 1 closeQty", (QFilter[])closeFilter, null);
        DataSet ds = beginDs.union(addDs.union(closeDs)).groupBy(new String[]{"company.name", "openorg.name", "acctproperty.name"}).sum("beginQty").sum("addQty").sum("closeQty").finish();
        ds = ds.addField("beginQty + addQty - closeQty", "endQty");
        return ds;
    }
}

