/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.report.bankacct.qing.data;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.am.report.bankacct.helper.QingRptFilterParamHelper;
import kd.tmc.fbp.common.enums.AcctStyleEnum;
import kd.tmc.fbp.common.enums.AcctTypeEnum;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.BankInterFaceEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.qing.data.AbstractQingAnlsDataPlugin;

public class AcctSumQingAnlsPlugin
extends AbstractQingAnlsDataPlugin {
    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{"company.name", ResManager.loadKDString((String)"\u7533\u8bf7\u516c\u53f8", (String)"AcctSumQingAnlsPlugin_0", (String)"tmc-am-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"openorg.name", ResManager.loadKDString((String)"\u5f00\u6237\u516c\u53f8", (String)"AcctSumQingAnlsPlugin_1", (String)"tmc-am-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"name", ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\u540d\u79f0", (String)"AcctSumQingAnlsPlugin_2", (String)"tmc-am-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"bankaccountnumber", ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7", (String)"AcctSumQingAnlsPlugin_3", (String)"tmc-am-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"fintypeorbank", ResManager.loadKDString((String)"\u94f6\u884c\u7c7b\u522b/\u91d1\u878d\u673a\u6784", (String)"AcctSumQingAnlsPlugin_4", (String)"tmc-am-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"finorginfo", ResManager.loadKDString((String)"\u91d1\u878d\u673a\u6784", (String)"AcctSumQingAnlsPlugin_5", (String)"tmc-am-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"acctproperty", ResManager.loadKDString((String)"\u8d26\u6237\u7528\u9014", (String)"AcctSumQingAnlsPlugin_6", (String)"tmc-am-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"acctstyle", ResManager.loadKDString((String)"\u8d26\u6237\u7c7b\u578b", (String)"AcctSumQingAnlsPlugin_7", (String)"tmc-am-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"accttype", ResManager.loadKDString((String)"\u8d26\u6237\u6027\u8d28", (String)"AcctSumQingAnlsPlugin_8", (String)"tmc-am-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"acctstatus", ResManager.loadKDString((String)"\u8d26\u6237\u72b6\u6001", (String)"AcctSumQingAnlsPlugin_9", (String)"tmc-am-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"issetbankinterface", ResManager.loadKDString((String)"\u94f6\u4f01\u63a5\u53e3", (String)"AcctSumQingAnlsPlugin_10", (String)"tmc-am-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"country", ResManager.loadKDString((String)"\u56fd\u5bb6\u6216\u5730\u533a", (String)"AcctSumQingAnlsPlugin_11", (String)"tmc-am-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"province", ResManager.loadKDString((String)"\u7701\u4efd", (String)"AcctSumQingAnlsPlugin_12", (String)"tmc-am-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"city", ResManager.loadKDString((String)"\u57ce\u5e02", (String)"AcctSumQingAnlsPlugin_13", (String)"tmc-am-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        String bankAcctSic = "name, bankaccountnumber,acctstatus, company.name, openorg.name, bank.id";
        DataSet bankAcctSet = QueryServiceHelper.queryDataSet((String)"BankAcctSum", (String)"bd_accountbanks", (String)bankAcctSic, (QFilter[])this.initBankAcctFilter(paramMap), null);
        String finOrgSic = "id, name finorginfo, country.name country, province.name province, city.name city,bank_cate.name,finorgtype.type";
        DataSet bankSet = QueryServiceHelper.queryDataSet((String)"BankAcctSum", (String)"bd_finorginfo", (String)finOrgSic, (QFilter[])this.initFinOrgFilter(paramMap), null);
        DataSet allBankSet = bankSet.addField("bank_cate.name||','||finorginfo||','||finorgtype.type", "fintypeorbank");
        return bankAcctSet.join(allBankSet).on("bank.id", "id").select(new String[]{"name", "bankaccountnumber", "acctstatus", "company.name", "openorg.name", "acctproperty", "acctstyle", "accttype", "issetbankinterface", "finorginfo", "finorgtype", "country", "province", "city", "fintypeorbank"}).finish();
    }

    protected Object translateCellDisplay(String field, Object value, Row rs) {
        switch (field) {
            case "fintypeorbank": {
                String[] finsplit = value.toString().split(",");
                if (finsplit[2].equals(FinOrgTypeEnum.BANK.getValue())) {
                    value = finsplit[0];
                    break;
                }
                value = finsplit[1];
                break;
            }
            case "acctstyle": {
                value = AcctStyleEnum.getName((String)((String)value));
                break;
            }
            case "issetbankinterface": {
                if (!FinOrgTypeEnum.BANK.getName().equals(rs.getString("finorgtype"))) {
                    value = false;
                }
                value = BankInterFaceEnum.getName((boolean)((Boolean)value));
                break;
            }
            case "accttype": {
                value = AcctTypeEnum.getName((String)((String)value));
                break;
            }
            case "acctstatus": {
                value = BankAcctStatusEnum.getName((String)((String)value));
            }
        }
        return value;
    }

    private QFilter[] initBankAcctFilter(Map<String, Object> paramMap) {
        QFilter filter = QingRptFilterParamHelper.initOrgFilter(paramMap);
        String isbeiinterface = (String)paramMap.get("isbeiinterface");
        if (!EmptyUtil.isEmpty((String)isbeiinterface)) {
            filter.and(new QFilter("issetbankinterface", "=", (Object)Boolean.valueOf(isbeiinterface)));
        }
        ArrayList<Long> acctuseIds = new ArrayList<Long>();
        if (!EmptyUtil.isEmpty((Object)paramMap.get("acctuse"))) {
            JSONArray acctuses = (JSONArray)paramMap.get("acctuse");
            for (Object e : acctuses) {
                acctuseIds.add(((JSONObject)e).getLong("id"));
            }
        }
        if (acctuseIds.size() > 0) {
            filter.and(new QFilter("acctproperty.id", "in", acctuseIds));
        }
        ArrayList<String> statusList = new ArrayList<String>();
        if (!EmptyUtil.isEmpty((Object)paramMap.get("status"))) {
            String[] statuss;
            for (String string : statuss = ((String)paramMap.get("status")).split(",")) {
                if (EmptyUtil.isEmpty((Object)string)) continue;
                statusList.add(string);
            }
        }
        if (statusList != null && statusList.size() > 0) {
            filter.and(new QFilter("acctstatus", "in", statusList));
        }
        if (EmptyUtil.isNotEmpty((CharSequence)((String)paramMap.get("opendateranges_startdate"))) && EmptyUtil.isNotEmpty((CharSequence)((String)paramMap.get("opendateranges_enddate")))) {
            Date openStartDate = DateUtils.stringToDate((String)((String)paramMap.get("opendateranges_startdate")), (String)"yyyy-MM-dd");
            Date date = DateUtils.stringToDate((String)((String)paramMap.get("opendateranges_enddate")), (String)"yyyy-MM-dd");
            filter.and(new QFilter("opendate", ">=", (Object)openStartDate).and(new QFilter("opendate", "<=", (Object)date)));
        }
        if (EmptyUtil.isNotEmpty((CharSequence)((String)paramMap.get("closedateranges_startdate"))) && EmptyUtil.isNotEmpty((CharSequence)((String)paramMap.get("closedateranges_enddate")))) {
            Date closeStartDate = DateUtils.stringToDate((String)((String)paramMap.get("closedateranges_startdate")), (String)"yyyy-MM-dd");
            Date date = DateUtils.stringToDate((String)((String)paramMap.get("closedateranges_enddate")), (String)"yyyy-MM-dd");
            filter.and(new QFilter("closedate", ">=", (Object)closeStartDate).and(new QFilter("closedate", "<=", (Object)date)));
        }
        return new QFilter[]{filter};
    }

    private QFilter[] initFinOrgFilter(Map<String, Object> paramMap) {
        boolean isincludefinorg = (Boolean)paramMap.get("isincludefinorg");
        QFilter filter = null;
        if (!isincludefinorg) {
            filter = new QFilter("finorgtype.type", "=", (Object)"0");
        }
        ArrayList<Long> bankIds = new ArrayList<Long>();
        if (!isincludefinorg && !EmptyUtil.isEmpty((Object)paramMap.get("banktype"))) {
            for (Object bank : (JSONArray)paramMap.get("banktype")) {
                bankIds.add(((JSONObject)bank).getLong("id"));
            }
        }
        if (bankIds.size() > 0) {
            if (EmptyUtil.isEmpty((Object)filter)) {
                filter = new QFilter("bank_cate.id", "in", bankIds);
            } else {
                filter.and(new QFilter("bank_cate.id", "in", bankIds));
            }
        }
        ArrayList<Long> finorgIds = new ArrayList<Long>();
        if (!isincludefinorg && !EmptyUtil.isEmpty((Object)paramMap.get("finorginfo"))) {
            for (Object finorginfo : (JSONArray)paramMap.get("finorginfo")) {
                finorgIds.add(((JSONObject)finorginfo).getLong("id"));
            }
        }
        if (finorgIds.size() > 0) {
            if (EmptyUtil.isEmpty((Object)filter)) {
                filter = new QFilter("id", "in", finorgIds);
            } else {
                filter.and(new QFilter("id", "in", finorgIds));
            }
        }
        if (EmptyUtil.isEmpty((Object)filter)) {
            return null;
        }
        return new QFilter[]{filter};
    }
}

