/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.report.bankacct.qing.data;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.am.report.bankacct.helper.QingRptFilterParamHelper;
import kd.tmc.fbp.common.enums.AcctStyleEnum;
import kd.tmc.fbp.common.enums.AcctTypeEnum;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.report.qing.data.AbstractQingAnlsDataPlugin;

public class DormantAcctQingAnlsPlugin
extends AbstractQingAnlsDataPlugin {
    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{"company.name", ResManager.loadKDString((String)"\u7533\u8bf7\u516c\u53f8", (String)"DormantAcctQingAnlsPlugin_0", (String)"tmc-am-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"openorg.name", ResManager.loadKDString((String)"\u5f00\u6237\u516c\u53f8", (String)"DormantAcctQingAnlsPlugin_1", (String)"tmc-am-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"bank.name", ResManager.loadKDString((String)"\u91d1\u878d\u673a\u6784", (String)"DormantAcctQingAnlsPlugin_2", (String)"tmc-am-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"bankaccountnumber", ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7", (String)"DormantAcctQingAnlsPlugin_3", (String)"tmc-am-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"name", ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\u540d\u79f0", (String)"DormantAcctQingAnlsPlugin_4", (String)"tmc-am-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"defaultcurrency.name", ResManager.loadKDString((String)"\u5e01\u79cd", (String)"DormantAcctQingAnlsPlugin_5", (String)"tmc-am-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"opendate", ResManager.loadKDString((String)"\u8d26\u6237\u5f00\u6237\u65e5\u671f", (String)"DormantAcctQingAnlsPlugin_6", (String)"tmc-am-report", (Object[])new Object[0]), QingFieldType.Date.toNumber(), false});
        field.add(new Object[]{"acctstatus", ResManager.loadKDString((String)"\u8d26\u6237\u72b6\u6001", (String)"DormantAcctQingAnlsPlugin_7", (String)"tmc-am-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"acctstyle", ResManager.loadKDString((String)"\u8d26\u6237\u7c7b\u578b", (String)"DormantAcctQingAnlsPlugin_8", (String)"tmc-am-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"accttype", ResManager.loadKDString((String)"\u8d26\u6237\u6027\u8d28", (String)"DormantAcctQingAnlsPlugin_9", (String)"tmc-am-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"acctproperty.name", ResManager.loadKDString((String)"\u8d26\u6237\u7528\u9014", (String)"DormantAcctQingAnlsPlugin_10", (String)"tmc-am-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"manager.name", ResManager.loadKDString((String)"\u8d26\u6237\u7ba1\u7406\u4eba", (String)"DormantAcctQingAnlsPlugin_11", (String)"tmc-am-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"tradecount", ResManager.loadKDString((String)"\u4ea4\u6613\u7b14\u6570", (String)"DormantAcctQingAnlsPlugin_12", (String)"tmc-am-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"totalAmount", ResManager.loadKDString((String)"\u4ea4\u6613\u91cf", (String)"DormantAcctQingAnlsPlugin_13", (String)"tmc-am-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        Date queryStartDate = DateUtils.stringToDate((String)((String)paramMap.get("dateranges_startdate")), (String)"yyyy-MM-dd");
        Date queryEndDate = DateUtils.stringToDate((String)((String)paramMap.get("dateranges_enddate")), (String)"yyyy-MM-dd");
        QFilter dailytimefilter = new QFilter("bizdate", ">=", (Object)queryStartDate).and(new QFilter("bizdate", "<=", (Object)queryEndDate));
        QFilter acctimefilter = new QFilter("opendate", "<=", (Object)queryStartDate);
        Integer tradenumber = (Integer)paramMap.get("tradenumber");
        QFilter statusfilter = new QFilter("acctstatus", "=", (Object)BankAcctStatusEnum.NORMAL.getValue());
        QFilter orgfilter = QingRptFilterParamHelper.initOrgFilter(paramMap);
        boolean isincludefinorg = (Boolean)paramMap.get("isincludefinorg");
        QFilter finorgtypefilter = null;
        if (!isincludefinorg) {
            ArrayList<String> isfin = new ArrayList<String>();
            isfin.add(FinOrgTypeEnum.CLEARINGHOUSE.getValue());
            isfin.add(FinOrgTypeEnum.FINCOMP.getValue());
            finorgtypefilter = new QFilter("finorgtype", "not in", isfin);
        }
        QFilter[] acctfilters = new QFilter[]{acctimefilter, statusfilter, orgfilter, finorgtypefilter};
        QFilter[] dailyFilters = new QFilter[]{dailytimefilter};
        DataSet acctDataSet = QueryServiceHelper.queryDataSet((String)"dormantAcct", (String)"bd_accountbanks", (String)this.getAcctSelectedFieds(), (QFilter[])acctfilters, null);
        DataSet dailyAllDataSet = QueryServiceHelper.queryDataSet((String)"dormantAcct", (String)"cas_bankjournal", (String)this.getDailySelectedFieds(), (QFilter[])dailyFilters, null).groupBy(new String[]{"accountbank.bankaccountnumber"}).count("tradecount").sum("debitamount").sum("creditamount").finish();
        HashMap<String, Integer> count = new HashMap<String, Integer>();
        count.put("tradenumber", tradenumber);
        DataSet daDataSet = acctDataSet.join(dailyAllDataSet, JoinType.LEFT).on("bankaccountnumber", "accountbank.bankaccountnumber").select(new String[]{"company.name", "openorg.name", "bank.name", "bankaccountnumber", "name", "defaultcurrency.name", "opendate", "acctstatus", "acctstyle", "accttype", "acctproperty.name", "manager.name"}, new String[]{"accountbank.bankaccountnumber", "tradecount", "debitamount", "creditamount"}).finish();
        daDataSet = daDataSet.addField("debitamount + creditamount", "totalAmount").filter("tradecount<tradenumber", count);
        return daDataSet;
    }

    private String getAcctSelectedFieds() {
        return "company.name,openorg.name,bank.name,bankaccountnumber,name,defaultcurrency.name,opendate,acctstatus,acctstyle,accttype,acctproperty.name,manager.name";
    }

    private String getDailySelectedFieds() {
        return "accountbank.bankaccountnumber,bizdate, bookdate,debitamount,creditamount";
    }

    protected Object translateCellDisplay(String field, Object value, Row rs) {
        switch (field) {
            case "acctstatus": {
                value = BankAcctStatusEnum.getName((String)((String)value));
                break;
            }
            case "accttype": {
                value = AcctTypeEnum.getName((String)((String)value));
                break;
            }
            case "acctstyle": {
                value = AcctStyleEnum.getName((String)((String)value));
                break;
            }
            case "totalAmount": {
                value = value == null ? Integer.valueOf(0) : value;
                break;
            }
            case "tradecount": {
                value = value == null ? Integer.valueOf(0) : value;
            }
        }
        return value;
    }
}

