/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.ebservice.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.am.business.ebservice.api.IEBServiceFacade;
import kd.tmc.am.business.ebservice.service.EBServiceFactory;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.data.NoteResult;
import kd.tmc.fbp.service.ebservice.service.IEBService;
import kd.tmc.fbp.service.ebservice.service.executor.EBServiceExecutor;

public class EBServiceFacadeImpl
implements IEBServiceFacade {
    private static final String SYNC_MAPPED_ACCT = "syncMappedAcct";
    private static final Log logger = LogFactory.getLog(EBServiceFacadeImpl.class);

    @Override
    public List<NoteResult> syncMappedAcct(List<Long> draftIdList) {
        NoteResult resultList = new ArrayList();
        ArrayList<String> requestSuccessIds = new ArrayList<String>();
        ArrayList<Long> requestFailIds = new ArrayList<Long>();
        List idLists = draftIdList.stream().map(String::valueOf).collect(Collectors.toList());
        Map request = MutexServiceHelper.batchRequest(idLists, (String)"am_proxyinquiryaccount", (String)SYNC_MAPPED_ACCT);
        try {
            List requestDatas;
            NoteResult result;
            for (Map.Entry entry : request.entrySet()) {
                String key = (String)entry.getKey();
                if (((Boolean)entry.getValue()).booleanValue()) {
                    requestSuccessIds.add(key);
                    continue;
                }
                requestFailIds.add(Long.valueOf(key));
            }
            if (requestFailIds.size() > 0) {
                DynamicObject[] failDataArr = BusinessDataServiceHelper.load((Object[])requestFailIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"am_proxyinquiryaccount"));
                NoteResult ebResult = new NoteResult();
                TmcErrorCode tmcErrorCode = new TmcErrorCode();
                for (DynamicObject data : failDataArr) {
                    ebResult.setStatusCode(EBResultStatusCode.ERROR);
                    ebResult.setErrMsg(tmcErrorCode.BILL_MUTEX_LOCK_WITH_NUMBER(data.getString("id")).getMessage());
                    result = ebResult;
                    result.setBillId(Long.valueOf(data.getLong("id")));
                    resultList.add(result);
                }
            }
            if (EmptyUtil.isEmpty(requestDatas = draftIdList.stream().filter(draft -> requestSuccessIds.contains(String.valueOf(draft))).collect(Collectors.toList()))) {
                result = resultList;
                return result;
            }
            DynamicObject[] objs = BusinessDataServiceHelper.load((Object[])requestDatas.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"am_proxyinquiryaccount"));
            EBServiceExecutor executor = new EBServiceExecutor();
            IEBService<List<NoteResult>> service = EBServiceFactory.syncMappedAcct(Arrays.asList(objs));
            List res = (List)executor.execute(service);
            resultList.addAll(res);
        }
        catch (Exception ex) {
            logger.error("\u4ee3\u7406\u67e5\u8be2\u540c\u6b65\u94f6\u4f01\u5f02\u5e38\uff1a" + ex);
            throw ex;
        }
        finally {
            MutexServiceHelper.batchRelease(idLists, (String)"am_proxyinquiryaccount", (String)SYNC_MAPPED_ACCT);
        }
        return resultList;
    }
}

