/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.ebservice.log;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.fbp.common.log.bean.BankLogDetail;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;

public class BankLogInfoElcFactory {
    public static BankLogInfo generateBatchBankLog(List<DynamicObject> dataList) {
        BankLogInfo logInfo = new BankLogInfo();
        ArrayList<BankLogDetail> detailList = new ArrayList<BankLogDetail>(dataList.size());
        logInfo.setLogDetailList(detailList);
        String entityName = "am_proxyinquiryaccount";
        Long currencyId = dataList.get(0).getLong("currency.id");
        logInfo.setPayCurrencyId(currencyId);
        DynamicObject org = dataList.get(0).getDynamicObject("org");
        logInfo.setOrgid(Long.valueOf(org.getLong("id")));
        logInfo.setPayTotalAmt(BigDecimal.ZERO);
        logInfo.setEntityName(entityName);
        for (DynamicObject data : dataList) {
            BankLogDetail bankDetail = new BankLogDetail();
            bankDetail.setBillId(Long.valueOf(data.getLong("id")));
            bankDetail.setBillNumber(data.getString("proxyinquiryaccount"));
            bankDetail.setBillType(entityName);
            bankDetail.setBillOrgId(Long.valueOf(data.getDynamicObject("org").getLong("id")));
            bankDetail.setAcctBankId(Long.valueOf(data.getDynamicObject("bankacct").getLong("id")));
            bankDetail.setBillType(entityName);
            bankDetail.setPayAmt(BigDecimal.ZERO);
            detailList.add(bankDetail);
        }
        return logInfo;
    }
}

