/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.ebservice.request.datasource;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.am.business.ebservice.entity.ChildAcctDetail;
import kd.tmc.am.business.ebservice.entity.SyncMappedAcctRequestBody;
import kd.tmc.am.business.ebservice.entity.SyncMappedAcctRequestBodyDetail;
import kd.tmc.am.business.ebservice.request.datasource.IBankAcctRequestDataSource;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class SyncMappedAcctRequestDataSource
implements IBankAcctRequestDataSource {
    private static final Log logger = LogFactory.getLog(SyncMappedAcctRequestDataSource.class);
    private List<DynamicObject> bills;

    public SyncMappedAcctRequestDataSource() {
    }

    public SyncMappedAcctRequestDataSource(List<DynamicObject> bills) {
        this.bills = bills;
    }

    @Override
    public SyncMappedAcctRequestBody getSyncMappedAcctRequestBody() {
        Object[] distinctBankAcctIds = this.bills.stream().map(o -> o.getDynamicObject("bankacct").getLong("id")).distinct().toArray();
        logger.info("SyncMappedAcctRequestDataSource getSyncMappedAcctRequestBody distinctBankAcctIds = " + Arrays.toString(distinctBankAcctIds));
        DynamicObject[] bankAccounts = TmcDataServiceHelper.load((Object[])distinctBankAcctIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountbanks"));
        SyncMappedAcctRequestBody body = new SyncMappedAcctRequestBody();
        ArrayList<SyncMappedAcctRequestBodyDetail> bodyDetailList = new ArrayList<SyncMappedAcctRequestBodyDetail>(this.bills.size());
        for (DynamicObject bankAccount : bankAccounts) {
            SyncMappedAcctRequestBodyDetail bodyDetail = new SyncMappedAcctRequestBodyDetail();
            bodyDetail.setParentAcct(bankAccount.getString("number"));
            QFilter qFilter = new QFilter("bankacct", "=", bankAccount.getPkValue());
            DynamicObject[] proxyInquiryAccounts = TmcDataServiceHelper.load((String)"am_proxyinquiryaccount", (String)"id,bankacct,bank,currency,proxyinquiryaccount,currency,enable", (QFilter[])new QFilter[]{qFilter});
            ArrayList<ChildAcctDetail> childAcctDetails = new ArrayList<ChildAcctDetail>(proxyInquiryAccounts.length);
            bodyDetail.setChildAccts(childAcctDetails);
            for (DynamicObject proxyInquiryAccount : proxyInquiryAccounts) {
                if (!proxyInquiryAccount.getBoolean("enable")) continue;
                ChildAcctDetail childAcctDetail = new ChildAcctDetail();
                childAcctDetail.setAccNo(proxyInquiryAccount.getString("proxyinquiryaccount"));
                childAcctDetail.setCurrency(proxyInquiryAccount.getDynamicObject("currency").getString("number"));
                childAcctDetail.setSwiftCode(proxyInquiryAccount.getDynamicObject("bank") == null ? "" : proxyInquiryAccount.getDynamicObject("bank").getString("swift_code"));
                childAcctDetails.add(childAcctDetail);
            }
            bodyDetailList.add(bodyDetail);
        }
        body.setTables(bodyDetailList);
        return body;
    }

    @Override
    public String getAcctNo() {
        return this.bills.get(0).getDynamicObject("bankacct").getString("number");
    }

    @Override
    public String getCurrency() {
        DynamicObject dynamicObject = this.bills.get(0).getDynamicObject("currency");
        if (dynamicObject != null) {
            return dynamicObject.getString("number");
        }
        return "";
    }

    @Override
    public String getSubBizTypeOp() {
        return "syncMappedAcct";
    }
}

