/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.ebservice.service;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.am.business.ebservice.entity.SyncMappedAcctResponseBody;
import kd.tmc.am.business.ebservice.log.BankLogInfoElcFactory;
import kd.tmc.am.business.ebservice.request.builder.SyncMappedAcctRequestBuilder;
import kd.tmc.am.business.ebservice.request.datasource.SyncMappedAcctRequestDataSource;
import kd.tmc.am.business.service.integration.BankCateHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.data.NoteResult;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.service.ebservice.service.IEBService;

public class SyncMappedAcctServiceImpl
implements IEBService<List<NoteResult>> {
    private static final Log logger = LogFactory.getLog(SyncMappedAcctServiceImpl.class);
    private final List<DynamicObject> bills;
    private final List<NoteResult> result;

    public SyncMappedAcctServiceImpl(List<DynamicObject> bills) {
        this.bills = bills;
        this.result = new ArrayList<NoteResult>(bills.size());
        for (DynamicObject bill : bills) {
            NoteResult noteResult = new NoteResult();
            noteResult.setBillId(Long.valueOf(bill.getLong("id")));
            this.result.add(noteResult);
        }
    }

    public boolean validate() {
        return true;
    }

    public void beforeRequest() {
    }

    public void rollback(String errMsg, Exception e) {
        for (NoteResult noteResult : this.result) {
            noteResult.setStatusCode(EBResultStatusCode.ROLLBACK);
            noteResult.setErrMsg(String.format(ResManager.loadKDString((String)"\u540c\u6b65\u94f6\u4f01\u4e91\u5f02\u5e38:%s", (String)"SyncMappedAcctServiceImpl_0", (String)"tmc-am-business", (Object[])new Object[0]), errMsg));
        }
    }

    public void handleEBException(String resultBody, String errMsg, Exception e) {
        for (NoteResult noteResult : this.result) {
            noteResult.setStatusCode(EBResultStatusCode.ERROR);
            noteResult.setErrMsg(String.format(ResManager.loadKDString((String)"\u540c\u6b65\u94f6\u4f01\u4e91\u5f02\u5e38:%s", (String)"SyncMappedAcctServiceImpl_0", (String)"tmc-am-business", (Object[])new Object[0]), errMsg));
        }
    }

    public void handleResultBody(String resultBody) {
        logger.info(" resultBody:" + resultBody);
        SyncMappedAcctResponseBody syncMappedAcctResponseBody = (SyncMappedAcctResponseBody)JSON.parseObject((String)resultBody, SyncMappedAcctResponseBody.class);
        if (syncMappedAcctResponseBody != null && syncMappedAcctResponseBody.getTables() != null && syncMappedAcctResponseBody.getTables().size() > 0) {
            DynamicObject[] distinctBills;
            logger.info("SyncMappedAcctServiceImpl handleResultBody syncMappedAcctResponseBody = " + syncMappedAcctResponseBody);
            for (NoteResult noteResult : this.result) {
                noteResult.setStatusCode(EBResultStatusCode.SUCCESS);
            }
            Object[] distinctBankAcctIds = this.bills.stream().map(o -> o.getDynamicObject("bankacct").getLong("id")).distinct().toArray();
            logger.info("SyncMappedAcctServiceImpl handleResultBody distinctBankAcctIds = " + distinctBankAcctIds);
            QFilter distinctBankAcctFilter = new QFilter("bankacct", "in", (Object)distinctBankAcctIds);
            DynamicObjectCollection allSelectSyncBills = QueryServiceHelper.query((String)"am_proxyinquiryaccount", (String)"id", (QFilter[])new QFilter[]{distinctBankAcctFilter});
            Object[] distinctIds = allSelectSyncBills.stream().map(o -> o.getLong("id")).toArray();
            for (DynamicObject distinctBill : distinctBills = TmcDataServiceHelper.load((Object[])distinctIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"am_proxyinquiryaccount"))) {
                distinctBill.set("issync", (Object)"1");
                distinctBill.set("syndate", (Object)new Date());
            }
            SaveServiceHelper.save((DynamicObject[])distinctBills);
        } else {
            for (NoteResult noteResult : this.result) {
                noteResult.setStatusCode(EBResultStatusCode.ERROR);
                noteResult.setErrMsg(ResManager.loadKDString((String)"\u540c\u6b65\u94f6\u4f01\u4e91\u5f02\u5e38:%s", (String)"SyncMappedAcctServiceImpl_0", (String)"tmc-am-business", (Object[])new Object[0]));
            }
        }
    }

    public IEBRequestBuilder getRequestBuilder() {
        return new SyncMappedAcctRequestBuilder(new SyncMappedAcctRequestDataSource(this.bills));
    }

    public String getEntityName() {
        return "am_proxyinquiryaccount";
    }

    public BankLogInfo getBankLogInfo() {
        return BankLogInfoElcFactory.generateBatchBankLog(this.bills);
    }

    public List<NoteResult> getEBResult() {
        return this.result;
    }

    public String getServiceUrl() {
        return "/kapi/app/aqap/aqap_service";
    }

    public Long getBankCateId() {
        return BankCateHelper.getBankCateId(this.bills.get(0).getDynamicObject("bankacct").getString("number"));
    }
}

