/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.opservice.bankacct;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.service.servicehlper.BankServiceHelper;

public class BankAcctDeletService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("issetbankinterface");
        selector.add("defaultcurrency");
        selector.add("bank");
        selector.add("acctname");
        selector.add("bankaccountnumber");
        selector.add("bebankfunc");
        selector.add("additionalproperty");
        selector.add("iselecpayment");
        selector.add("elecpaymenttype");
        selector.add("elecpaymentlevel");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject bankAcct : dataEntities) {
            boolean isSetBankInterface = bankAcct.getBoolean("issetbankinterface");
            if (!isSetBankInterface) continue;
            bankAcct.set("issetbankinterface", (Object)"0");
            BankServiceHelper.syncAccount((DynamicObject)bankAcct, (boolean)true);
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        DispatchServiceHelper.invokeBizService((String)"tmc", (String)"cdm", (String)"EleTicDirConSetSyncService", (String)"eleTicDirConSetSync", (Object[])new Object[]{dataEntities, "delete"});
        List collect = Arrays.stream(dataEntities).map(o -> o.getPkValue()).collect(Collectors.toList());
        Object[] proxyAcctDc = BusinessDataServiceHelper.load((String)"am_proxyinquiryaccount", (String)"org,bankacct,currency,proxyinquiryaccount,status,enable,issync,syndate", (QFilter[])new QFilter[]{new QFilter("bankacct", "in", collect)});
        if (EmptyUtil.isNoEmpty((Object[])proxyAcctDc)) {
            DeleteServiceHelper.delete((IDataEntityType)proxyAcctDc[0].getDynamicObjectType(), (Object[])proxyAcctDc);
        }
    }
}

