/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.opservice.bankacct;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.basedata.cache.BaseDataCtrlCacheMrg;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.service.servicehlper.BankServiceHelper;

public class BankAcctSaveService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(BankAcctSaveService.class);
    private boolean isSyncUp = false;
    private boolean isAcctNoChange = false;
    private boolean isSyncDel = false;
    private DynamicObject oldInfo = null;

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("company");
        selector.add("opendate");
        selector.add("finorgtype");
        selector.add("bank");
        selector.add("currency");
        selector.add("defaultcurrency");
        selector.add("org");
        selector.add("bankaccountnumber");
        selector.add("ismulcurrency");
        selector.add("creator");
        selector.add("acctstyle");
        selector.add("acctname");
        selector.add("bebankfunc");
        selector.add("bankinterface");
        selector.add("issetbankinterface");
        selector.add("acctstatus");
        selector.add("additionalproperty");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<DynamicObject> syncUpLs = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> syncDelLs = new ArrayList<DynamicObject>();
        for (DynamicObject bankAcct : dataEntities) {
            Object[] bankAcctPays;
            Object[] bankAcctRecs;
            bankAcct.set("org", bankAcct.get("company"));
            bankAcct.set("createorg", bankAcct.get("company"));
            bankAcct.set("number", bankAcct.get("bankaccountnumber"));
            DynamicObjectCollection currencys = bankAcct.getDynamicObjectCollection("currency");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)currencys) || currencys.size() == 1) {
                bankAcct.set("ismulcurrency", (Object)"0");
            } else {
                bankAcct.set("ismulcurrency", (Object)"1");
            }
            Object pkValue = bankAcct.getPkValue();
            boolean isSetBankInterface = bankAcct.getBoolean("issetbankinterface");
            if (null == pkValue) {
                if (isSetBankInterface) {
                    this.isSyncUp = true;
                }
            } else {
                boolean isExist = TmcDataServiceHelper.exists((Object)Long.valueOf(pkValue.toString()), (String)"bd_accountbanks");
                if (isExist) {
                    this.oldInfo = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"bd_accountbanks");
                    if (!this.oldInfo.getBoolean("issetbankinterface")) {
                        if (isSetBankInterface) {
                            this.isSyncUp = true;
                        }
                    } else if (!isSetBankInterface) {
                        this.isSyncDel = true;
                        bankAcct.set("bebankfunc", (Object)"");
                        bankAcct.set("bankinterface", (Object)"");
                    } else {
                        if (BankAcctStatusEnum.NORMAL.getValue().equals(this.oldInfo.getString("acctstatus")) && BankAcctStatusEnum.CLOSED.getValue().equals(bankAcct.getString("acctstatus"))) {
                            this.isSyncDel = true;
                        } else {
                            this.isSyncUp = BankAcctStatusEnum.CLOSED.getValue().equals(this.oldInfo.getString("acctstatus")) && BankAcctStatusEnum.NORMAL.getValue().equals(bankAcct.getString("acctstatus")) ? true : true;
                        }
                        if (!this.oldInfo.getString("bankaccountnumber").equals(bankAcct.getString("bankaccountnumber"))) {
                            this.isAcctNoChange = true;
                        }
                    }
                } else if (isSetBankInterface) {
                    this.isSyncUp = true;
                }
            }
            if (bankAcct.getBoolean("isdefaultrec") && !ArrayUtils.isEmpty((Object[])(bankAcctRecs = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"company,isdefaultpay,isdefaultrec,bankaccountnumber", (QFilter[])new QFilter[]{new QFilter("id", "!=", bankAcct.getPkValue()), new QFilter("company", "=", bankAcct.getDynamicObject("company").getPkValue()), new QFilter("isdefaultrec", "=", (Object)Boolean.TRUE), new QFilter("acctstatus", "!=", (Object)"closed")})))) {
                Arrays.stream(bankAcctRecs).forEach(bankAcctPay -> bankAcctPay.set("isdefaultrec", (Object)Boolean.FALSE));
                SaveServiceHelper.save((DynamicObject[])bankAcctRecs);
            }
            if (bankAcct.getBoolean("isdefaultpay") && !ArrayUtils.isEmpty((Object[])(bankAcctPays = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"company,isdefaultpay,isdefaultrec,bankaccountnumber", (QFilter[])new QFilter[]{new QFilter("id", "!=", bankAcct.getPkValue()), new QFilter("company", "=", bankAcct.getDynamicObject("company").getPkValue()), new QFilter("isdefaultpay", "=", (Object)Boolean.TRUE), new QFilter("acctstatus", "!=", (Object)"closed")})))) {
                Arrays.stream(bankAcctPays).forEach(bankAcctPay -> bankAcctPay.set("isdefaultpay", (Object)Boolean.FALSE));
                SaveServiceHelper.save((DynamicObject[])bankAcctPays);
            }
            if (bankAcct.getDynamicObject("inneracct") == null) {
                if (this.isSyncUp) {
                    if (this.isAcctNoChange) {
                        syncDelLs.add(this.oldInfo);
                    }
                    syncUpLs.add(bankAcct);
                } else if (this.isSyncDel) {
                    syncDelLs.add(bankAcct);
                }
            }
            this.isSyncUp = false;
            this.isAcctNoChange = false;
            this.isSyncDel = false;
        }
        if (syncDelLs.size() > 0) {
            this.syncAccountBank(syncDelLs, true);
        }
        if (syncUpLs.size() > 0) {
            this.syncAccountBank(syncUpLs, false);
        }
    }

    private void syncAccountBank(List<DynamicObject> bankAcct, Boolean isDelete) {
        try {
            BankServiceHelper.syncAccount(bankAcct, (boolean)isDelete);
        }
        catch (Exception e) {
            logger.error("BankAcctSaveService syncAccountBank exception:" + e.getMessage());
            throw new KDBizException("BankAcctSaveService syncAccountBank exception:" + e.getMessage());
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        for (DynamicObject bankAcct : dataEntities) {
            String key = "bd_accountbanks" + bankAcct.getDynamicObject("company").getLong("id");
            String type = BaseDataCtrlCacheMrg.getType4BaseDataFilter();
            BaseDataCtrlCacheMrg.clearCache((String)type, (String)key);
        }
        DispatchServiceHelper.invokeBizService((String)"tmc", (String)"cdm", (String)"EleTicDirConSetSyncService", (String)"eleTicDirConSetSync", (Object[])new Object[]{dataEntities, "save"});
    }
}

