/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.opservice.bankacct;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;

public class BankManagePermChangeService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(BankManagePermChangeService.class);

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        List ids = Arrays.stream(dynamicObjects).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        DynamicObjectCollection bankAccountsFromDB = QueryServiceHelper.query((String)"am_accountbank", (String)"id,company", (QFilter[])new QFilter("id", "in", ids).toArray());
        if (bankAccountsFromDB.size() > 0) {
            Map<Long, Long> idToCompanyIdMapFromDb = bankAccountsFromDB.stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v.getLong("company")));
            Map<Long, DynamicObject> idToAcctBankMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
            for (Map.Entry<Long, Long> idToCompanyIdFromDb : idToCompanyIdMapFromDb.entrySet()) {
                Long acctBankId = idToCompanyIdFromDb.getKey();
                Long companyIdFromDb = idToCompanyIdFromDb.getValue();
                DynamicObject bankAcct = idToAcctBankMap.get(acctBankId);
                Long companyIdNew = bankAcct.getLong("company.id");
                if (companyIdNew == 0L || Objects.equals(companyIdFromDb, companyIdNew)) continue;
                ArrayList<Long> acctBankIds = new ArrayList<Long>(2);
                acctBankIds.add(acctBankId);
                logger.info("\u7ba1\u7406\u6743\u8f6c\u8ba9\uff0c\u94f6\u884c\u8d26\u53f7:{},\u8d26\u53f7ID:{}, \u539f\u7ec4\u7ec7ID:{}, \u76ee\u6807\u7ec4\u7ec7ID:{}, \u76ee\u6807\u7ec4\u7ec7\u540d\u79f0:{}", new Object[]{bankAcct.getString("bankaccountnumber"), acctBankIds, companyIdFromDb, companyIdNew, bankAcct.getString("company.name")});
                BaseDataServiceHelper.managePermChange((String)"am_accountbank", acctBankIds, (Long)companyIdNew);
            }
        }
    }
}

