/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.opservice.bankacct.management;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bd.service.AssignService;
import kd.bos.bd.service.ChangeManageRightService;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.basedata.BaseDataResponse;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.am.common.enums.AccountBankLogEnum;
import kd.tmc.am.common.helper.AcctBankLogHelper;
import kd.tmc.am.common.helper.PeriodHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.helper.CasBusinessHelper;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankAcctManageTransferAuditService
extends AbstractTmcBizOppService {
    private static Log LOGGER = LogFactory.getLog(BankAcctManageTransferAuditService.class);
    private static final String F_BASE_DATA_ID = "fbasedataid";
    private static final String ID = "id";
    private static final String APP_ID = "am";
    private DynamicObject[] accounts;

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("accountbank");
        selector.add("originorg");
        selector.add("targetorg");
        selector.add("billno");
        selector.add("transferdate");
        selector.add("billstatus");
        selector.add("transferreason");
        selector.add("transferor");
        selector.add("transferdate");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<DynamicObject> bankJournalList = new ArrayList<DynamicObject>(10);
        for (DynamicObject data2 : dataEntities) {
            DynamicObject dataAccount = data2.getDynamicObject("accountbank");
            DynamicObject originOrg = data2.getDynamicObject("originorg");
            DynamicObject targetOrg = data2.getDynamicObject("targetorg");
            bankJournalList.addAll(this.createBankJournalList(data2));
            HashSet<Long> dataIdSet = new HashSet<Long>(8);
            dataIdSet.add(dataAccount.getLong(ID));
            ChangeManageRightService service = new ChangeManageRightService();
            BaseDataResponse changeResponse = service.changeManageRight("am_accountbank", Long.valueOf(originOrg.getLong(ID)), APP_ID, dataIdSet, Long.valueOf(targetOrg.getLong(ID)), false);
            if (!changeResponse.isSuccess()) {
                throw new KDBizException(changeResponse.getErrorMsg());
            }
            HashSet<Long> orgIdSet = new HashSet<Long>(8);
            orgIdSet.add(originOrg.getLong(ID));
            BaseDataResponse assignResponse = new AssignService("bd_accountbanks").assign(Long.valueOf(targetOrg.getLong(ID)), APP_ID, dataIdSet, orgIdSet, true);
            if (assignResponse.isSuccess()) continue;
            throw new KDBizException(assignResponse.getErrorMsg());
        }
        Set accountIdSet = Arrays.stream(dataEntities).map(data -> data.getDynamicObject("accountbank").getPkValue()).collect(Collectors.toSet());
        this.accounts = BusinessDataServiceHelper.load((Object[])accountIdSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"am_accountbank"));
        Map idAndAccountMap = Arrays.stream(this.accounts).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity(), (a, b) -> a));
        for (DynamicObject data3 : dataEntities) {
            DynamicObject dataAccount = data3.getDynamicObject("accountbank");
            DynamicObject account = (DynamicObject)idAndAccountMap.get(dataAccount.getPkValue());
            DynamicObject targetOrg = data3.getDynamicObject("targetorg");
            String billNo = data3.getString("billno");
            account.set("company", (Object)targetOrg);
            account.set("useorg", (Object)targetOrg);
            account.set("isdefaultrec", (Object)false);
            account.set("isdefaultpay", (Object)false);
            data3.set("transferdate", (Object)DateUtils.getCurrentDate());
            DynamicObjectCollection transferEntries = account.getDynamicObjectCollection("transferentry");
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)transferEntries) || !transferEntries.stream().anyMatch(e -> StringUtils.equals((CharSequence)e.getString("transferbillno"), (CharSequence)billNo))) continue;
            DynamicObject transferEntry = transferEntries.stream().filter(e -> StringUtils.equals((CharSequence)e.getString("transferbillno"), (CharSequence)billNo)).findFirst().get();
            transferEntry.set("transferdate", (Object)data3.getDate("transferdate"));
            transferEntry.set("transferbillstatus", (Object)data3.getString("billstatus"));
        }
        SaveServiceHelper.save((DynamicObject[])this.accounts);
        try (TXHandle tx = TX.requiresNew();){
            try {
                if (EmptyUtil.isNoEmpty(bankJournalList)) {
                    SaveServiceHelper.save((DynamicObject[])bankJournalList.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e2) {
                tx.markRollback();
                throw e2;
            }
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        try {
            if (EmptyUtil.isNoEmpty((Object[])this.accounts)) {
                AcctBankLogHelper.getInstance().addAcctBankLogByDynamic(this.accounts, AccountBankLogEnum.ACCOUNT_SAVE.getValue());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8bb0\u5f55\u94f6\u884c\u53d8\u66f4\u65e5\u5fd7\u5931\u8d25\uff0c\u4e0d\u5f71\u54cd\u672c\u6b21\u7ba1\u7406\u6743\u8f6c\u8ba9\u64cd\u4f5c\uff0c\u4f46\u662f\u9700\u8981\u91cd\u65b0\u4fdd\u5b58\u8be5\u94f6\u884c\u8d26\u6237\u3002", (Throwable)e);
            throw new KDException(BosErrorCode.systemError, new Object[]{ResManager.loadKDString((String)"\u8bb0\u5f55\u94f6\u884c\u53d8\u66f4\u65e5\u5fd7\u5931\u8d25\uff0c\u4e0d\u5f71\u54cd\u672c\u6b21\u7ba1\u7406\u6743\u8f6c\u8ba9\u64cd\u4f5c\uff0c\u4f46\u662f\u9700\u8981\u91cd\u65b0\u4fdd\u5b58\u8be5\u94f6\u884c\u8d26\u6237\u3002", (String)"BankAcctManageTransferAuditService_02", (String)"tmc-am-business", (Object[])new Object[0])});
        }
    }

    private List<DynamicObject> createBankJournalList(DynamicObject transferData) {
        ArrayList<DynamicObject> journalList = new ArrayList<DynamicObject>(10);
        DynamicObject bankAccount = transferData.getDynamicObject("accountbank");
        DynamicObject originOrg = transferData.getDynamicObject("originorg");
        DynamicObject targetOrg = transferData.getDynamicObject("targetorg");
        long bankAccountId = bankAccount.getLong(ID);
        DynamicObjectCollection currencies = bankAccount.getDynamicObjectCollection("currency");
        Date transferDate = transferData.getDate("transferdate");
        Long originPeriodId = PeriodHelper.getPeriodId((long)originOrg.getLong(ID), (Date)transferDate);
        Long targetPeriodId = PeriodHelper.getPeriodId((long)targetOrg.getLong(ID), (Date)transferDate);
        if (EmptyUtil.isEmpty((Long)originPeriodId) || EmptyUtil.isEmpty((Long)targetPeriodId)) {
            LOGGER.error("\u6ca1\u6709\u7ef4\u62a4\u671f\u95f4\u6570\u636e\uff1a\u539f\u7ec4\u7ec7\uff1a{}\uff0c\u539f\u7ec4\u7ec7\u671f\u95f4\uff1a{}\uff0c\u76ee\u6807\u7ec4\u7ec7\uff1a{}\uff0c\u76ee\u6807\u7ec4\u7ec7\u671f\u95f4\uff1a{}", new Object[]{originOrg.getLong(ID), originPeriodId, targetOrg.getLong(ID), targetPeriodId});
            return journalList;
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)currencies)) {
            currencies.forEach(dy -> {
                DynamicObject currency = dy.getDynamicObject(F_BASE_DATA_ID);
                BigDecimal balance = CasBusinessHelper.getBalanceFormCas((long)originOrg.getLong(ID), (long)bankAccountId, (long)currency.getLong(ID));
                if (EmptyUtil.isNoEmpty((BigDecimal)balance)) {
                    DynamicObject payJournalInfo = this.createJournalInfo(transferData, currency, balance, true, originPeriodId);
                    DynamicObject recJournalInfo = this.createJournalInfo(transferData, currency, balance, false, targetPeriodId);
                    journalList.add(payJournalInfo);
                    journalList.add(recJournalInfo);
                }
            });
        }
        return journalList;
    }

    private DynamicObject createJournalInfo(DynamicObject transferData, DynamicObject currency, BigDecimal balance, boolean payTo, Long periodId) {
        DynamicObject bankAccount = transferData.getDynamicObject("accountbank");
        Date transferDate = transferData.getDate("transferdate");
        DynamicObject originOrg = transferData.getDynamicObject("originorg");
        DynamicObject targetOrg = transferData.getDynamicObject("targetorg");
        String desc = ResManager.loadKDString((String)"\u4f59\u989d\u7ed3\u8f6c", (String)"BankAcctManageTransferAuditService_01", (String)"tmc-am-business", (Object[])new Object[0]);
        boolean positive = balance.compareTo(Constants.ZERO) > 0;
        DynamicObject journalInfo = BusinessDataServiceHelper.newDynamicObject((String)"cas_bankjournal");
        journalInfo.set("bizdate", (Object)transferDate);
        journalInfo.set("bookdate", (Object)transferDate);
        if (payTo) {
            journalInfo.set("org", (Object)originOrg);
            journalInfo.set("oppunit", (Object)targetOrg.getString("name"));
            journalInfo.set("creditamount", (Object)(positive ? balance.abs() : BigDecimal.ZERO));
            journalInfo.set("debitamount", (Object)(positive ? BigDecimal.ZERO : balance.abs()));
        } else {
            journalInfo.set("org", (Object)targetOrg);
            journalInfo.set("oppunit", (Object)originOrg.getString("name"));
            journalInfo.set("creditamount", (Object)(positive ? BigDecimal.ZERO : balance.abs()));
            journalInfo.set("debitamount", (Object)(positive ? balance.abs() : BigDecimal.ZERO));
        }
        journalInfo.set("period", (Object)periodId);
        journalInfo.set("description", (Object)desc);
        journalInfo.set("exchangerate", (Object)new BigDecimal("1"));
        journalInfo.set("oppbank", (Object)bankAccount.getDynamicObject("bank").getString("name"));
        journalInfo.set("oppacctnumber", (Object)bankAccount.getString("bankaccountnumber"));
        journalInfo.set("ischeck", (Object)true);
        journalInfo.set("datasource", (Object)"balancectrans");
        journalInfo.set("source", (Object)"6");
        journalInfo.set("currency", currency.getPkValue());
        journalInfo.set("basecurrency", currency.getPkValue());
        String billNo = CodeRuleHelper.generateNumber((String)"cas_bankjournal", (DynamicObject)journalInfo, (String)originOrg.getPkValue().toString(), null);
        journalInfo.set("billno", (Object)billNo);
        journalInfo.set("accountbank", bankAccount.getPkValue());
        journalInfo.set("openorg", originOrg.getPkValue());
        return journalInfo;
    }
}

