/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.opservice.bankacct.management;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankAcctManageTransferDeleteService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("accountbank");
        selector.add("originorg");
        selector.add("targetorg");
        selector.add("billno");
        selector.add("transferdate");
        selector.add("billstatus");
        selector.add("transferreason");
        selector.add("transferor");
        selector.add("transferdate");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        Set accountIdSet = Arrays.stream(dataEntities).map(data -> data.getDynamicObject("accountbank").getPkValue()).collect(Collectors.toSet());
        DynamicObject[] accounts = BusinessDataServiceHelper.load((Object[])accountIdSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_accountbanks"));
        Map idAndAccountMap = Arrays.stream(accounts).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity(), (a, b) -> a));
        for (DynamicObject data2 : dataEntities) {
            DynamicObjectCollection viewOrgEntries;
            DynamicObject dataAccount = data2.getDynamicObject("accountbank");
            DynamicObject account = (DynamicObject)idAndAccountMap.get(dataAccount.getPkValue());
            DynamicObject originOrg = data2.getDynamicObject("originorg");
            String billNo = data2.getString("billno");
            DynamicObjectCollection transferEntries = account.getDynamicObjectCollection("transferentry");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)transferEntries)) {
                transferEntries.removeIf(e -> StringUtils.equals((CharSequence)e.getString("transferbillno"), (CharSequence)billNo));
            }
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)(viewOrgEntries = account.getDynamicObjectCollection("transfervieworgentry")))) continue;
            Set orgIdSet = viewOrgEntries.stream().map(e -> e.getDynamicObject("transfervieworg").getLong("id")).collect(Collectors.toSet());
            Map originOrgList = TmcDataServiceHelper.loadFromCache((String)"am_management_transfer", (String)"originorg", (QFilter[])new QFilter[]{new QFilter("accountbank", "=", account.getPkValue())});
            if (!CollectionUtils.isEmpty((Map)originOrgList)) {
                originOrgList.forEach((key, transfer) -> {
                    if (!orgIdSet.contains(key)) {
                        DynamicObject viewOrgEntry = viewOrgEntries.addNew();
                        viewOrgEntry.set("transfervieworg", (Object)transfer.getDynamicObject("originorg"));
                    }
                });
            }
            viewOrgEntries.removeIf(e -> e.getDynamicObject("transfervieworg").getLong("id") == originOrg.getLong("id"));
        }
        SaveServiceHelper.save((DynamicObject[])accounts);
    }
}

