/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.opservice.bankacct.management;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankAcctManageTransferUnSubmitService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("accountbank");
        selector.add("originorg");
        selector.add("targetorg");
        selector.add("billno");
        selector.add("transferdate");
        selector.add("billstatus");
        selector.add("transferreason");
        selector.add("transferor");
        selector.add("transferdate");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        Set accountIdSet = Arrays.stream(dataEntities).map(data -> data.getDynamicObject("accountbank").getPkValue()).collect(Collectors.toSet());
        DynamicObject[] accounts = BusinessDataServiceHelper.load((Object[])accountIdSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_accountbanks"));
        Map idAndAccountMap = Arrays.stream(accounts).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity(), (a, b) -> a));
        for (DynamicObject data2 : dataEntities) {
            DynamicObject dataAccount = data2.getDynamicObject("accountbank");
            DynamicObject account = (DynamicObject)idAndAccountMap.get(dataAccount.getPkValue());
            String billNo = data2.getString("billno");
            DynamicObjectCollection transferEntries = account.getDynamicObjectCollection("transferentry");
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)transferEntries) || !transferEntries.stream().anyMatch(e -> StringUtils.equals((CharSequence)e.getString("transferbillno"), (CharSequence)billNo))) continue;
            DynamicObject transferEntry = transferEntries.stream().filter(e -> StringUtils.equals((CharSequence)e.getString("transferbillno"), (CharSequence)billNo)).findFirst().get();
            transferEntry.set("transferbillstatus", (Object)data2.getString("billstatus"));
        }
        SaveServiceHelper.save((DynamicObject[])accounts);
    }
}

