/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.opservice.changeapply;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ChangeApplyAuditService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(ChangeApplyAuditService.class);
    private List<DynamicObject> innerAccountList = new ArrayList<DynamicObject>(1);
    List<DynamicObject> bankAcctList;
    Map<Object, DynamicObject> allBankAcctMap = new HashMap<Object, DynamicObject>(10);

    public List<String> getSelector() {
        super.getSelector();
        ArrayList<String> sic = new ArrayList<String>(10);
        sic.add("e_accountbank");
        sic.add("applydate");
        sic.add("applyuser");
        sic.add("entryentity");
        sic.add("entryentity2");
        sic.add(String.join((CharSequence)".", "entryentity", "e_changefield"));
        sic.add(String.join((CharSequence)".", "entryentity", "e_beforechange"));
        sic.add(String.join((CharSequence)".", "entryentity", "e_afterchange"));
        sic.add(String.join((CharSequence)".", "entryentity", "e_reason"));
        sic.add(String.join((CharSequence)".", "entryentity", "e_basedatatype"));
        sic.add(String.join((CharSequence)".", "entryentity", "e_basedata"));
        sic.add(String.join((CharSequence)".", "entryentity", "e_currency"));
        sic.add(String.join((CharSequence)".", "entryentity", "e_settlementtype"));
        sic.add(String.join((CharSequence)".", "entryentity", "e_changefieldname"));
        sic.add(String.join((CharSequence)".", "entryentity", "multigoods"));
        sic.add(String.join((CharSequence)".", "entryentity", "e_relatedsettleacct"));
        sic.add("netbankgrantentity");
        sic.add(String.join((CharSequence)".", "netbankgrantentity", "netbankaccount"));
        sic.add(String.join((CharSequence)".", "netbankgrantentity", "netgrant"));
        sic.add(String.join((CharSequence)".", "netbankgrantentity", "operator"));
        sic.add(String.join((CharSequence)".", "netbankgrantentity", "goods"));
        sic.add(String.join((CharSequence)".", "netbankgrantentity", "netgrantcur"));
        sic.add(String.join((CharSequence)".", "netbankgrantentity", "approvedamount"));
        sic.add(String.join((CharSequence)".", "netbankgrantentity", "netsrcentryid"));
        sic.add("entrysignetentity");
        sic.add(String.join((CharSequence)".", "entrysignetentity", "signetbankaccount"));
        sic.add(String.join((CharSequence)".", "entrysignetentity", "signettype"));
        sic.add(String.join((CharSequence)".", "entrysignetentity", "signetname"));
        sic.add(String.join((CharSequence)".", "entrysignetentity", "signetsrcentryid"));
        sic.add(String.join((CharSequence)".", "entrysignetentity", "signetkeeper"));
        sic.add("virtualentity");
        sic.add(String.join((CharSequence)".", "virtualentity", "virtualaccount"));
        sic.add(String.join((CharSequence)".", "virtualentity", "virtualbankaccount"));
        sic.add(String.join((CharSequence)".", "virtualentity", "virtualsrcentryid"));
        sic.add(String.join((CharSequence)".", "virtualentity", "openbank"));
        sic.add(String.join((CharSequence)".", "virtualentity", "remark"));
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        try {
            this.bankAcctList = new ArrayList<DynamicObject>(dataEntities.length);
            Map allFields = MetadataServiceHelper.getDataEntityType((String)"am_accountbank").getAllFields();
            for (DynamicObject data : dataEntities) {
                DynamicObjectCollection entrySignetEntity = data.getDynamicObjectCollection("entrysignetentity");
                DynamicObjectCollection netBankGrantEntity = data.getDynamicObjectCollection("netbankgrantentity");
                DynamicObjectCollection virtualEntity = data.getDynamicObjectCollection("virtualentity");
                DynamicObjectCollection entryEntity = data.getDynamicObjectCollection("entryentity");
                DynamicObjectCollection accountEntryEntities = data.getDynamicObjectCollection("entryentity2");
                Object[] bankAcctIds = accountEntryEntities.stream().map(o -> o.getDynamicObject("e_accountbank").getPkValue()).toArray();
                DynamicObject[] bankAccounts = TmcDataServiceHelper.load((Object[])bankAcctIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"am_accountbank"));
                Map<Object, DynamicObject> bankAcctMap = Arrays.stream(bankAccounts).collect(Collectors.toMap(DataEntityBase::getPkValue, v -> v));
                this.allBankAcctMap.putAll(bankAcctMap);
                for (DynamicObject accountEntryEntity : accountEntryEntities) {
                    Object entry2;
                    DynamicObject bankAcct = bankAcctMap.get(accountEntryEntity.getDynamicObject("e_accountbank").getPkValue());
                    for (Object entry2 : entryEntity) {
                        String changeFieldName = entry2.getString("e_changefield");
                        IDataEntityProperty property = (IDataEntityProperty)allFields.get(changeFieldName);
                        if (property instanceof BasedataProp) {
                            Object changeFieldValue = entry2.get("e_basedata");
                            bankAcct.set(changeFieldName, changeFieldValue);
                            continue;
                        }
                        if (property instanceof MulBasedataProp) {
                            DynamicObjectCollection changeFieldValue = null;
                            if ("currency".equals(changeFieldName)) {
                                changeFieldValue = entry2.getDynamicObjectCollection("e_currency");
                            } else if ("settlementtype".equals(changeFieldName)) {
                                changeFieldValue = entry2.getDynamicObjectCollection("e_settlementtype");
                            } else if ("multigoods".equals(changeFieldName)) {
                                changeFieldValue = entry2.getDynamicObjectCollection("multigoods");
                            } else if ("relatedsettleacct".equals(changeFieldName)) {
                                changeFieldValue = entry2.getDynamicObjectCollection("e_relatedsettleacct");
                            }
                            if (changeFieldValue == null) continue;
                            DynamicObject[] collArray = (DynamicObject[])changeFieldValue.stream().map(row -> row.getDynamicObject("fbasedataid")).toArray(DynamicObject[]::new);
                            DynamicObjectCollection collMulti = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)bankAcct, (String)changeFieldName, (DynamicObject[])collArray);
                            bankAcct.set(changeFieldName, (Object)collMulti);
                            continue;
                        }
                        if (property instanceof DateProp) {
                            Object changeFieldValue = entry2.get("e_afterchange");
                            bankAcct.set(changeFieldName, (Object)DateUtils.stringToDate((String)changeFieldValue.toString(), (String)"yyyy-MM-dd"));
                            continue;
                        }
                        if (property instanceof BooleanProp) {
                            boolean changeFieldValue = entry2.getBoolean("e_afterchange");
                            if ("issetbankinterface".equals(changeFieldName) && !changeFieldValue) {
                                bankAcct.set("bebankfunc", null);
                            } else if ("isopenbank".equals(changeFieldName) && !changeFieldValue) {
                                bankAcct.set("bankfunc", null);
                                bankAcct.set("netbank", null);
                            } else if (("isdefaultpay".equals(changeFieldName) || "isdefaultrec".equals(changeFieldName)) && changeFieldValue) {
                                long orgId = bankAcct.getDynamicObject("company").getLong("id");
                                QFilter defaultFilter = new QFilter("company", "=", (Object)orgId).and("acctstatus", "!=", (Object)"closed");
                                defaultFilter.and(changeFieldName, "=", (Object)true);
                                DynamicObject[] bankAcctsFromDB = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,company,isdefaultpay,isdefaultrec,bankaccountnumber", (QFilter[])new QFilter[]{defaultFilter});
                                if (bankAcctsFromDB != null && bankAcctsFromDB.length > 0) {
                                    DynamicObject defaultPayOrRecAcct = bankAcctsFromDB[0];
                                    defaultPayOrRecAcct.set(changeFieldName, (Object)false);
                                    SaveServiceHelper.update((DynamicObject)defaultPayOrRecAcct);
                                }
                            }
                            bankAcct.set(changeFieldName, (Object)changeFieldValue);
                            continue;
                        }
                        if (!(property instanceof ComboProp) && !(property instanceof AmountProp) && !(property instanceof TextProp) && !(property instanceof IntegerProp) && !(property instanceof DecimalProp)) continue;
                        Object changeFieldValue = entry2.get("e_afterchange");
                        bankAcct.set(changeFieldName, changeFieldValue);
                    }
                    DynamicObjectCollection bankAcctSig = bankAcct.getDynamicObjectCollection("entrysignetentity");
                    bankAcctSig.clear();
                    entry2 = entrySignetEntity.iterator();
                    while (entry2.hasNext()) {
                        DynamicObject signetEntity = (DynamicObject)entry2.next();
                        Object changeAccountId = signetEntity.getDynamicObject("signetbankaccount").getPkValue();
                        if (!bankAcct.getPkValue().equals(changeAccountId)) continue;
                        Object srcEntryId = signetEntity.get("signetsrcentryid");
                        DynamicObject row2 = bankAcctSig.addNew();
                        if (EmptyUtil.isNoEmpty((Object)srcEntryId)) {
                            row2.set("id", (Object)row2);
                        }
                        row2.set("signettype", signetEntity.get("signettype"));
                        row2.set("signetname", signetEntity.get("signetname"));
                        row2.set("signetkeeper", signetEntity.get("signetkeeper"));
                    }
                    DynamicObjectCollection bankAcctNet = bankAcct.getDynamicObjectCollection("netbankgrantentity");
                    bankAcctNet.clear();
                    for (DynamicObject netBankEntity : netBankGrantEntity) {
                        Object changeAccountId = netBankEntity.getDynamicObject("netbankaccount").getPkValue();
                        if (!bankAcct.getPkValue().equals(changeAccountId)) continue;
                        Object srcEntryId = netBankEntity.get("netsrcentryid");
                        DynamicObject row3 = bankAcctNet.addNew();
                        if (EmptyUtil.isNoEmpty((Object)srcEntryId)) {
                            row3.set("id", (Object)row3);
                        }
                        row3.set("netgrant", netBankEntity.get("netgrant"));
                        row3.set("operator", netBankEntity.get("operator"));
                        row3.set("goods", netBankEntity.get("goods"));
                        row3.set("netgrantcur", netBankEntity.get("netgrantcur"));
                        row3.set("approvedamount", netBankEntity.get("approvedamount"));
                    }
                    DynamicObjectCollection bankAccountVirtual = bankAcct.getDynamicObjectCollection("virtualentity");
                    bankAccountVirtual.clear();
                    for (DynamicObject entity : virtualEntity) {
                        Object changeAccountId = entity.getDynamicObject("virtualbankaccount").getPkValue();
                        if (!bankAcct.getPkValue().equals(changeAccountId)) continue;
                        Object srcEntryId = entity.get("virtualsrcentryid");
                        DynamicObject row4 = bankAccountVirtual.addNew();
                        if (EmptyUtil.isNoEmpty((Object)srcEntryId)) {
                            row4.set("id", (Object)row4);
                        }
                        row4.set("virtualaccount", entity.get("virtualaccount"));
                        row4.set("openbank", entity.get("openbank"));
                        row4.set("remark", entity.get("remark"));
                    }
                    if (bankAcct.get("inneracct") != null) {
                        this.innerAccountList.add(bankAcct);
                        continue;
                    }
                    bankAcct.set("acctstatus", (Object)BankAcctStatusEnum.NORMAL.getValue());
                    this.bankAcctList.add(bankAcct);
                }
            }
        }
        catch (Exception e) {
            logger.error("ChangeApplyAuditService exception:" + e.getMessage());
            throw new KDBizException(e.getMessage());
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        try {
            OperateOption create;
            if (this.bankAcctList.size() > 0) {
                create = OperateOption.create();
                create.setVariableValue("isneedvalidate", "false");
                create.setVariableValue("isfromchangeapply", "true");
                this.operationResult = TmcOperateServiceHelper.execOperate((String)"save", (String)"am_accountbank", (DynamicObject[])this.bankAcctList.toArray(new DynamicObject[0]), (OperateOption)create);
                logger.info("ChangeApplyAuditService afterProcess bankAcctList operationResult :" + this.operationResult.isSuccess());
            }
            if (this.innerAccountList.size() > 0) {
                for (DynamicObject dataEntity : dataEntities) {
                    dataEntity.set("billstatus", (Object)"H");
                }
                SaveServiceHelper.save((DynamicObject[])dataEntities);
                create = OperateOption.create();
                create.setVariableValue("isneedvalidate", "false");
                create.setVariableValue("isfromchangeapply", "true");
                for (DynamicObject innerAccount : this.innerAccountList) {
                    DynamicObject ifmInnerAccount = BusinessDataServiceHelper.loadSingle((Object)innerAccount.getDynamicObject("inneracct").getPkValue(), (String)"ifm_inneracct");
                    ifmInnerAccount.set("acctstatus", (Object)"changing");
                    TmcOperateServiceHelper.execOperate((String)"save", (String)"ifm_inneracct", (DynamicObject[])new DynamicObject[]{ifmInnerAccount}, (OperateOption)create);
                    this.operationResult = TmcOperateServiceHelper.execOperate((String)"pushinneraccount", (String)"am_changeapply", (DynamicObject[])dataEntities, (OperateOption)create);
                    logger.info("ChangeApplyAuditService afterProcess innerAccountList ifmInnerAccount operationResult :" + this.operationResult.isSuccess());
                }
            }
            ArrayList<Object> saveObjs = new ArrayList<Object>(2);
            ArrayList<DynamicObject> deleteObjs = new ArrayList<DynamicObject>(2);
            for (OperateOption dataEntity : dataEntities) {
                DynamicObjectCollection accountEntryEntities = dataEntity.getDynamicObjectCollection("entryentity2");
                Object[] bankAcctIds = accountEntryEntities.stream().map(o -> o.getDynamicObject("e_accountbank").getPkValue()).toArray();
                Object[] bankAccounts = TmcDataServiceHelper.load((Object[])bankAcctIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"am_accountbank"));
                if (!EmptyUtil.isNoEmpty((Object[])bankAccounts)) continue;
                List collect = Arrays.stream(bankAccounts).map(o -> o.getPkValue()).collect(Collectors.toList());
                DynamicObject[] proxyAcctDc = BusinessDataServiceHelper.load((String)"am_proxyinquiryaccount", (String)"org,bankacct,currency,proxyinquiryaccount,status,enable,issync,syndate", (QFilter[])new QFilter[]{new QFilter("bankacct", "in", collect)});
                for (Object bankAcct : bankAccounts) {
                    List proxyAccts = Arrays.stream(proxyAcctDc).filter(arg_0 -> ChangeApplyAuditService.lambda$afterProcess$6((DynamicObject)bankAcct, arg_0)).collect(Collectors.toList());
                    String beBankFunc = bankAcct.getString("bebankfunc");
                    if (!beBankFunc.contains("proxyinquiry")) {
                        if (proxyAccts == null || proxyAccts.size() <= 0) continue;
                        for (DynamicObject proxyAcct : proxyAccts) {
                            proxyAcct.set("status", (Object)"A");
                            proxyAcct.set("enable", (Object)"0");
                        }
                        saveObjs.addAll(proxyAccts);
                        continue;
                    }
                    DynamicObject proxyCurrency = bankAcct.getDynamicObject("proxycurrency");
                    String proxyInquiryAccount = bankAcct.getString("proxyinquiryaccount");
                    if (EmptyUtil.isNoEmpty((DynamicObject)proxyCurrency) && EmptyUtil.isNoEmpty((String)proxyInquiryAccount)) {
                        DynamicObject proxyAcct = Arrays.stream(proxyAcctDc).filter(arg_0 -> ChangeApplyAuditService.lambda$afterProcess$7((DynamicObject)bankAcct, proxyCurrency, arg_0)).findFirst().orElse(null);
                        if (EmptyUtil.isNoEmpty((DynamicObject)proxyAcct)) {
                            proxyAcct.set("proxyinquiryaccount", (Object)proxyInquiryAccount);
                            saveObjs.add(proxyAcct);
                            continue;
                        }
                        saveObjs.add(this.newProxyAcctDy((DynamicObject)bankAcct));
                        continue;
                    }
                    DynamicObject oldBankAcct = this.allBankAcctMap.get(bankAcct.getPkValue());
                    if (!EmptyUtil.isNoEmpty((DynamicObject)oldBankAcct)) continue;
                    DynamicObject oldProxyCurrency = oldBankAcct.getDynamicObject("proxycurrency");
                    DynamicObject proxyAcct = Arrays.stream(proxyAcctDc).filter(o -> oldBankAcct.getPkValue().equals(o.getDynamicObject("bankacct").getPkValue()) && oldProxyCurrency.getPkValue().equals(o.getDynamicObject("currency").getPkValue())).findFirst().orElse(null);
                    if (!EmptyUtil.isNoEmpty((DynamicObject)proxyAcct)) continue;
                    deleteObjs.add(proxyAcct);
                }
            }
            if (saveObjs.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])saveObjs.toArray(new DynamicObject[0]));
            }
            if (deleteObjs.size() > 0) {
                DeleteServiceHelper.delete((IDataEntityType)((DynamicObject)deleteObjs.get(0)).getDynamicObjectType(), (Object[])deleteObjs.toArray(new DynamicObject[0]));
            }
        }
        catch (Exception e) {
            logger.error("ChangeApplyAuditService afterProcess exception:" + e.getMessage());
            for (OperateOption dataEntity : dataEntities) {
                dataEntity.set("billstatus", (Object)"B");
            }
            SaveServiceHelper.save((DynamicObject[])dataEntities);
            throw e;
        }
    }

    private DynamicObject newProxyAcctDy(DynamicObject dataEntity) {
        String proxyInquiryAccount = dataEntity.getString("proxyinquiryaccount");
        if (EmptyUtil.isNoEmpty((String)proxyInquiryAccount)) {
            DynamicObject proxyInquiryAcct = BusinessDataServiceHelper.newDynamicObject((String)"am_proxyinquiryaccount");
            proxyInquiryAcct.set("status", (Object)"C");
            proxyInquiryAcct.set("enable", (Object)"1");
            proxyInquiryAcct.set("bankacct_id", dataEntity.getPkValue());
            proxyInquiryAcct.set("org_id", dataEntity.getDynamicObject("company").getPkValue());
            proxyInquiryAcct.set("bank_id", dataEntity.getDynamicObject("bank").getPkValue());
            proxyInquiryAcct.set("proxyinquiryaccount", (Object)dataEntity.getString("proxyinquiryaccount"));
            proxyInquiryAcct.set("currency_id", dataEntity.getDynamicObject("proxycurrency").getPkValue());
            proxyInquiryAcct.set("creator_id", dataEntity.getDynamicObject("creator").getPkValue());
            return proxyInquiryAcct;
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$afterProcess$7(DynamicObject bankAcct, DynamicObject proxyCurrency, DynamicObject o) {
        return bankAcct.getPkValue().equals(o.getDynamicObject("bankacct").getPkValue()) && proxyCurrency.getPkValue().equals(o.getDynamicObject("currency").getPkValue());
    }

    private static /* synthetic */ boolean lambda$afterProcess$6(DynamicObject bankAcct, DynamicObject o) {
        return bankAcct.getPkValue().equals(o.getDynamicObject("bankacct").getPkValue());
    }
}

