/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.opservice.changeapply;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.am.common.enums.InnerAcctStatusEnum;
import kd.tmc.am.common.helper.AccountBankHelper;
import kd.tmc.am.common.helper.AmBotpHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ChangeApplyUnSubmitService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        super.getSelector();
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("accountbank");
        sic.add("applydate");
        sic.add("applyuser");
        sic.add(String.join((CharSequence)".", "entryentity2", "e_accountbank"));
        sic.add(String.join((CharSequence)".", "e_accountbank", "finorgtype"));
        sic.add(String.join((CharSequence)".", "e_accountbank", "bankaccountnumber"));
        sic.add(String.join((CharSequence)".", "e_accountbank", "inneracct"));
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject data : dataEntities) {
            DynamicObjectCollection accountEntryEntities = data.getDynamicObjectCollection("entryentity2");
            for (DynamicObject accountEntryEntity : accountEntryEntities) {
                DynamicObject bankAcct = accountEntryEntity.getDynamicObject("e_accountbank");
                bankAcct = TmcDataServiceHelper.loadSingle((Object)bankAcct.getPkValue(), (String)"am_accountbank", (String)"acctstatus");
                bankAcct.set("acctstatus", (Object)BankAcctStatusEnum.NORMAL.getValue());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bankAcct});
            }
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        String entityName = dataEntities[0].getDataEntityType().getName();
        String targetEntityName = "ifm_accountacceptancebill";
        HashSet<Long> ifmBillId = new HashSet<Long>(10);
        for (DynamicObject dyObj : dataEntities) {
            DynamicObjectCollection acctEntries = dyObj.getDynamicObjectCollection("entryentity2");
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)acctEntries)) continue;
            for (DynamicObject entry : acctEntries) {
                Long pkValue;
                Long targetBillId;
                String bankAccountNumber;
                DynamicObject accountBank = entry.getDynamicObject("e_accountbank");
                if (!EmptyUtil.isNoEmpty((DynamicObject)accountBank)) continue;
                String finOrgType = accountBank.getString("finorgtype");
                if (!FinOrgTypeEnum.CLEARINGHOUSE.getValue().equals(finOrgType) || !EmptyUtil.isNoEmpty((String)(bankAccountNumber = accountBank.getString("bankaccountnumber"))) || (targetBillId = AmBotpHelper.getTargetBill((String)entityName, (Long)(pkValue = (Long)dyObj.getPkValue()), (String)targetEntityName)) == 0L) continue;
                AmBotpHelper.deleteBotpRation((Long)pkValue, (Long)targetBillId);
                ifmBillId.add(targetBillId);
            }
        }
        AccountBankHelper.deleteIfmInnerBill(ifmBillId);
        AccountBankHelper.updateInnerAcctStatus((DynamicObject[])dataEntities, (String)InnerAcctStatusEnum.NORMAL.getValue());
    }
}

