/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.opservice.closeacct;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;

public class BankAcctCloseAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("accountbank");
        selector.add("closereason");
        selector.add("closedate");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        for (DynamicObject data : dataEntities) {
            DynamicObject bankAcct = data.getDynamicObject("accountbank");
            bankAcct = TmcDataServiceHelper.loadSingle((Object)bankAcct.getPkValue(), (String)"am_accountbank");
            Date closeDate = data.getDate("closedate");
            String closeReason = data.getString("closereason");
            bankAcct.set("acctstatus", (Object)BankAcctStatusEnum.NORMAL.getValue());
            bankAcct.set("closedate", (Object)closeDate);
            bankAcct.set("closereason", (Object)closeReason);
            OperateOption create = OperateOption.create();
            create.setVariableValue("isneedvalidate", "false");
            TmcOperateServiceHelper.execOperate((String)"closeacct", (String)"am_accountbank", (DynamicObject[])new DynamicObject[]{bankAcct}, (OperateOption)create);
        }
        Object[] pkValues = Arrays.stream(dataEntities).map(o -> o.getDynamicObject("accountbank").getPkValue()).toArray();
        DynamicObject[] bankAccts = TmcDataServiceHelper.load((Object[])pkValues, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"am_accountbank"));
        DispatchServiceHelper.invokeBizService((String)"tmc", (String)"cdm", (String)"EleTicDirConSetSyncService", (String)"eleTicDirConSetSync", (Object[])new Object[]{bankAccts, "delete"});
        DynamicObject[] proxyAcctDc = BusinessDataServiceHelper.load((String)"am_proxyinquiryaccount", (String)"org,bankacct,currency,proxyinquiryaccount,status,enable,issync,syndate", (QFilter[])new QFilter[]{new QFilter("bankacct", "in", (Object)pkValues)});
        if (proxyAcctDc != null && proxyAcctDc.length > 0) {
            for (DynamicObject proxyAcct : proxyAcctDc) {
                proxyAcct.set("status", (Object)"A");
                proxyAcct.set("enable", (Object)"0");
            }
            SaveServiceHelper.save((DynamicObject[])proxyAcctDc);
        }
    }
}

