/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.opservice.closeacct;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.service.servicehlper.BankServiceHelper;

public class BankAcctCloseService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("accountbank");
        selector.add("acctstatus");
        selector.add("closereason");
        selector.add("closedate");
        selector.add("issetbankinterface");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject bankAcct : dataEntities) {
            Map param = this.getOperationVariable();
            if (!EmptyUtil.isEmpty((Object)param)) {
                String reason = (String)param.get("closereason");
                String closeDate = (String)param.get("closedate");
                if (!EmptyUtil.isEmpty((String)reason)) {
                    bankAcct.set("closereason", (Object)reason);
                }
                if (!EmptyUtil.isEmpty((String)closeDate)) {
                    bankAcct.set("closedate", (Object)DateUtils.stringToDate((String)closeDate, (String)"yyyy-MM-dd HH:mm:ss"));
                }
            }
            bankAcct.set("acctstatus", (Object)BankAcctStatusEnum.CLOSED.getValue());
            boolean isSetBankInterface = bankAcct.getBoolean("issetbankinterface");
            DynamicObject info = TmcDataServiceHelper.loadSingle((Object)bankAcct.getPkValue(), (String)"bd_accountbanks");
            if (info.getDynamicObject("inneracct") != null || !isSetBankInterface) continue;
            bankAcct.set("issetbankinterface", (Object)"0");
            BankServiceHelper.syncAccount((DynamicObject)info, (boolean)true);
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        Object[] pkValues = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).toArray();
        DynamicObject[] bankAccts = TmcDataServiceHelper.load((Object[])pkValues, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"am_accountbank"));
        DispatchServiceHelper.invokeBizService((String)"tmc", (String)"cdm", (String)"EleTicDirConSetSyncService", (String)"eleTicDirConSetSync", (Object[])new Object[]{bankAccts, "delete"});
        List collect = Arrays.stream(bankAccts).map(o -> o.getPkValue()).collect(Collectors.toList());
        DynamicObject[] proxyAcctDc = BusinessDataServiceHelper.load((String)"am_proxyinquiryaccount", (String)"org,bankacct,currency,proxyinquiryaccount,status,enable,issync,syndate", (QFilter[])new QFilter[]{new QFilter("bankacct", "in", collect)});
        if (proxyAcctDc != null && proxyAcctDc.length > 0) {
            for (DynamicObject proxyAcct : proxyAcctDc) {
                proxyAcct.set("status", (Object)"A");
                proxyAcct.set("enable", (Object)"0");
            }
            SaveServiceHelper.save((DynamicObject[])proxyAcctDc);
        }
    }
}

