/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.opservice.closeacct;

import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.am.common.enums.InnerAcctStatusEnum;
import kd.tmc.am.common.helper.AccountBankHelper;
import kd.tmc.am.common.helper.AmBotpHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankAcctCloseUnsubmitService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(BankAcctCloseUnsubmitService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("accountbank");
        selector.add("acctstatus");
        selector.add(String.join((CharSequence)".", "accountbank", "finorgtype"));
        selector.add(String.join((CharSequence)".", "accountbank", "bankaccountnumber"));
        selector.add(String.join((CharSequence)".", "accountbank", "inneracct"));
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        DynamicObject bankAcct = null;
        for (DynamicObject closeBill : dataEntities) {
            bankAcct = closeBill.getDynamicObject("accountbank");
            bankAcct = TmcDataServiceHelper.loadSingle((Object)bankAcct.getPkValue(), (DynamicObjectType)bankAcct.getDynamicObjectType());
            bankAcct.set("acctstatus", (Object)BankAcctStatusEnum.NORMAL.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bankAcct});
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        String entityName = dataEntities[0].getDataEntityType().getName();
        String targetEntityName = "ifm_accountacceptancebill";
        HashSet<Long> ifmBillId = new HashSet<Long>(10);
        for (DynamicObject dyObj : dataEntities) {
            String bankAccountNumber;
            DynamicObject acctBankDy = dyObj.getDynamicObject("accountbank");
            if (!EmptyUtil.isNoEmpty((DynamicObject)acctBankDy)) continue;
            String finOrgType = acctBankDy.getString("finorgtype");
            if (!FinOrgTypeEnum.CLEARINGHOUSE.getValue().equals(finOrgType) || !EmptyUtil.isNoEmpty((String)(bankAccountNumber = acctBankDy.getString("bankaccountnumber")))) continue;
            Long pkValue = (Long)dyObj.getPkValue();
            Long targetBillId = AmBotpHelper.getTargetBill((String)entityName, (Long)pkValue, (String)targetEntityName);
            logger.info("BankAcctCloseUnsubmitService afterProcess entityName:{}, pkValue:{},targetEntityName:{},targetBillId:{}", new Object[]{entityName, pkValue, targetEntityName, targetBillId});
            if (targetBillId == 0L) continue;
            AmBotpHelper.deleteBotpRation((Long)pkValue, (Long)targetBillId);
            ifmBillId.add(targetBillId);
        }
        AccountBankHelper.deleteIfmInnerBill(ifmBillId);
        AccountBankHelper.updateInnerAcctStatus((DynamicObject[])dataEntities, (String)InnerAcctStatusEnum.NORMAL.getValue());
    }
}

