/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.opservice.closeacct;

import java.util.Arrays;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.am.common.helper.AmBotpHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BankCloseStatusEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;

public class InnerBankAcctCloseAuditService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(InnerBankAcctCloseAuditService.class);

    public void process(DynamicObject[] dataEntities) {
    }

    public void beforeCommit(DynamicObject[] dataEntities) {
        boolean result;
        super.beforeCommit(dataEntities);
        try {
            OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"pushandsave", (String)"am_acctclosebill", (Object[])this.mapPkValues(dataEntities), (OperateOption)OperateOption.create(), (boolean)true);
            result = operationResult.isSuccess();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
        if (!result) {
            KDBizException kdBizException = new KDBizException(TmcOperateServiceHelper.decodeErrorMsg((OperationResult)this.operationResult));
            logger.error((Throwable)kdBizException);
            throw kdBizException;
        }
    }

    public void handlerException(DynamicObject[] dataEntities) {
        super.handlerException(dataEntities);
        this.rollBackData(dataEntities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollBackData(DynamicObject[] dataEntities) {
        Object[] targetBillIds = new Long[dataEntities.length];
        String entityName = dataEntities[0].getDataEntityType().getName();
        String targetEntityName = "ifm_accountacceptancebill";
        try (DynamicObject[] txHandle = TX.requiresNew();){
            try {
                for (int i = 0; i < this.mapPkValues(dataEntities).length; ++i) {
                    Long pkValue = this.mapPkValues(dataEntities)[i];
                    Long targetBillId = AmBotpHelper.getTargetBill((String)entityName, (Long)pkValue, (String)targetEntityName);
                    if (targetBillId != 0L) {
                        AmBotpHelper.deleteBotpRation((Long)pkValue, (Long)targetBillId);
                    }
                    targetBillIds[i] = targetBillId;
                }
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw e;
            }
        }
        finally {
            for (DynamicObject dataEntity : dataEntities) {
                dataEntity.set("billstatus", (Object)BankCloseStatusEnum.CLOSE_AUDITING.getValue());
            }
            TmcOperateServiceHelper.execOperate((String)"innersave", (String)entityName, (Object[])this.mapPkValues(dataEntities), (OperateOption)OperateOption.create());
        }
        DynamicObject[] existTargetBills = BusinessDataServiceHelper.load((String)"ifm_accountacceptancebill", (String)"id", (QFilter[])new QFilter("id", "in", (Object)targetBillIds).toArray());
        if (existTargetBills.length > 0) {
            targetBillIds = (Long[])Arrays.stream(existTargetBills).map(d -> (Long)d.getPkValue()).toArray(Long[]::new);
            TmcOperateServiceHelper.execOperate((String)"delete", (String)targetEntityName, (Object[])targetBillIds, (OperateOption)OperateOption.create(), (boolean)true);
        }
    }

    private Long[] mapPkValues(DynamicObject[] dataEntities) {
        Long[] pkValues = new Long[dataEntities.length];
        for (int i = 0; i < dataEntities.length; ++i) {
            pkValues[i] = (Long)dataEntities[i].getPkValue();
        }
        return pkValues;
    }
}

