/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.opservice.goods;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;

public class HoldGoodsAuditService
extends AbstractTmcBizOppService {
    private static final Integer INITIAL_CAPACITY = 100;
    private static final String FPKID = "fpkid";

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("objectdetail");
        sic.add("entryentity");
        sic.add(this.stringJoin("objectdetail", "objecttype"));
        sic.add(this.stringJoin("objectdetail", "objectname"));
        sic.add(this.stringJoin("objectdetail", "objectno"));
        sic.add(this.stringJoin("objectdetail", "startdate"));
        sic.add(this.stringJoin("objectdetail", "enddate"));
        sic.add(this.stringJoin("objectdetail", "authority"));
        sic.add(this.stringJoin("objectdetail", "keeper"));
        sic.add(this.stringJoin("objectdetail", "attachment"));
        sic.add(this.stringJoin("objectdetail", "associatedtype"));
        sic.add(this.stringJoin("entryentity", "associatedtype"));
        sic.add(this.stringJoin("entryentity", "billinfo"));
        sic.add(this.stringJoin("entryentity", "billid"));
        sic.add(this.stringJoin("objectdetail", "explain"));
        return sic;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        ArrayList<DynamicObject> dObjectList = new ArrayList<DynamicObject>(INITIAL_CAPACITY);
        for (DynamicObject data : dynamicObjects) {
            DynamicObject org = data.getDynamicObject("org");
            DynamicObjectCollection doCollectionDetail = data.getDynamicObjectCollection("objectdetail");
            for (DynamicObject dynamicObjectDetail : doCollectionDetail) {
                DynamicObject inventoryGoods = this.setEntityDetail(org, dynamicObjectDetail);
                this.setEntityCollection(dynamicObjectDetail, inventoryGoods);
                dObjectList.add(inventoryGoods);
            }
        }
        SaveServiceHelper.save((DynamicObject[])dObjectList.toArray(new DynamicObject[0]));
    }

    private DynamicObject setEntityDetail(DynamicObject org, DynamicObject dynamicObjectDetail) {
        DynamicObject objectType = dynamicObjectDetail.getDynamicObject("objecttype");
        String objectNo = dynamicObjectDetail.getString("objectno");
        String objectName = dynamicObjectDetail.getString("objectname");
        Date startDate = dynamicObjectDetail.getDate("startdate");
        Date endDate = dynamicObjectDetail.getDate("enddate");
        String authority = dynamicObjectDetail.getString("authority");
        DynamicObject keeperDy = dynamicObjectDetail.getDynamicObject("keeper");
        String description = dynamicObjectDetail.getString("explain");
        long keeper = 0L;
        if (keeperDy != null) {
            keeper = Long.parseLong(keeperDy.getPkValue().toString());
        }
        DynamicObject cloneEntity = (DynamicObject)OrmUtils.clone((Object)dynamicObjectDetail, (IDataEntityType)dynamicObjectDetail.getDataEntityType(), (boolean)true, (boolean)true);
        MulBasedataDynamicObjectCollection cloneMbdoc = (MulBasedataDynamicObjectCollection)cloneEntity.get("attachment");
        for (int i = 0; i < cloneMbdoc.size(); ++i) {
            DynamicObject mbdo = (DynamicObject)cloneMbdoc.get(i);
            mbdo.set(FPKID, null);
        }
        DynamicObject inventoryGoods = BusinessDataServiceHelper.newDynamicObject((String)"am_inventorygoodmanager");
        inventoryGoods.set("org", (Object)org);
        inventoryGoods.set("objecttype", (Object)objectType);
        inventoryGoods.set("number", (Object)objectNo);
        inventoryGoods.set("goodsname", (Object)objectName);
        inventoryGoods.set("startdate", (Object)startDate);
        inventoryGoods.set("enddate", (Object)endDate);
        inventoryGoods.set("permission", (Object)authority);
        inventoryGoods.set("keeper", (Object)keeper);
        inventoryGoods.set("status", (Object)"C");
        inventoryGoods.set("enable", (Object)"1");
        inventoryGoods.set("attachment", (Object)cloneMbdoc);
        inventoryGoods.set("goodstatus", (Object)"A");
        inventoryGoods.set("description", (Object)description);
        return inventoryGoods;
    }

    private void setEntityCollection(DynamicObject dynamicObjectDetail, DynamicObject inventoryGoods) {
        DynamicObjectCollection subEntryEntity = dynamicObjectDetail.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryEntity : subEntryEntity) {
            String associatedType = entryEntity.getString("associatedtype");
            String billInfo = entryEntity.getString("billinfo");
            DynamicObjectCollection entity = inventoryGoods.getDynamicObjectCollection("entryentity");
            DynamicObject dObject = entity.addNew();
            dObject.set("associatedtype", (Object)associatedType);
            dObject.set("billinfo", (Object)billInfo);
            dObject.set("billid", (Object)entryEntity.getString("billid"));
        }
    }

    private String stringJoin(String entity, String field) {
        return String.join((CharSequence)".", entity, field);
    }
}

