/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.opservice.openacct;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.am.common.helper.AmBotpHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BankOpenStatusEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;

public class InnerBankAcctOpenAuditService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(InnerBankAcctOpenAuditService.class);

    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>();
        selector.add("finorgtype");
        return selector;
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        boolean result;
        DynamicObject[] innerAcctOpenDynamicObjects = (DynamicObject[])Arrays.stream(dataEntities).filter(d -> Objects.equals(d.getString("finorgtype"), FinOrgTypeEnum.CLEARINGHOUSE.getValue())).toArray(DynamicObject[]::new);
        if (innerAcctOpenDynamicObjects.length == 0) {
            return;
        }
        super.beforeCommit(innerAcctOpenDynamicObjects);
        try {
            OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"pushinner", (String)"am_accopenbill", (Object[])this.mapPkValues(innerAcctOpenDynamicObjects), (OperateOption)OperateOption.create(), (boolean)true);
            result = operationResult.isSuccess();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
        if (!result) {
            KDBizException kdBizException = new KDBizException(TmcOperateServiceHelper.decodeErrorMsg((OperationResult)this.operationResult));
            logger.error((Throwable)kdBizException);
            throw kdBizException;
        }
    }

    private Long[] mapPkValues(DynamicObject[] dataEntities) {
        Long[] pkValues = new Long[dataEntities.length];
        for (int i = 0; i < dataEntities.length; ++i) {
            pkValues[i] = (Long)dataEntities[i].getPkValue();
        }
        return pkValues;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollBackData(DynamicObject[] dataEntities) {
        Object[] targetBillIds = new Long[dataEntities.length];
        String entityName = dataEntities[0].getDataEntityType().getName();
        String targetEntityName = "ifm_accountacceptancebill";
        try (DynamicObject[] txHandle = TX.requiresNew();){
            try {
                for (int i = 0; i < this.mapPkValues(dataEntities).length; ++i) {
                    Long pkValue = this.mapPkValues(dataEntities)[i];
                    Long targetBillId = AmBotpHelper.getTargetBill((String)entityName, (Long)pkValue, (String)targetEntityName);
                    if (targetBillId != 0L) {
                        AmBotpHelper.deleteBotpRation((Long)pkValue, (Long)targetBillId);
                    }
                    targetBillIds[i] = targetBillId;
                }
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw e;
            }
        }
        finally {
            for (DynamicObject dataEntity : dataEntities) {
                dataEntity.set("billstatus", (Object)BankOpenStatusEnum.OPEN_AUDITING.getValue());
            }
            TmcOperateServiceHelper.execOperate((String)"innersave", (String)entityName, (DynamicObject[])dataEntities, (OperateOption)OperateOption.create());
        }
        DynamicObject[] existTargetBills = BusinessDataServiceHelper.load((String)"ifm_accountacceptancebill", (String)"id", (QFilter[])new QFilter("id", "in", (Object)targetBillIds).toArray());
        if (existTargetBills.length > 0) {
            targetBillIds = (Long[])Arrays.stream(existTargetBills).map(d -> (Long)d.getPkValue()).toArray(Long[]::new);
            TmcOperateServiceHelper.execOperate((String)"delete", (String)targetEntityName, (Object[])targetBillIds, (OperateOption)OperateOption.create(), (boolean)true);
        }
    }

    public void handlerException(DynamicObject[] dataEntities) throws KDException {
        DynamicObject[] innerAcctOpenDynamicObjects = (DynamicObject[])Arrays.stream(dataEntities).filter(d -> Objects.equals(d.getString("finorgtype"), FinOrgTypeEnum.CLEARINGHOUSE.getValue())).toArray(DynamicObject[]::new);
        if (innerAcctOpenDynamicObjects.length == 0) {
            return;
        }
        super.handlerException(innerAcctOpenDynamicObjects);
        this.rollBackData(innerAcctOpenDynamicObjects);
    }
}

