/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.opservice.proxyaccount;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.am.business.ebservice.api.EBServiceFacadeFactory;
import kd.tmc.am.business.ebservice.api.IEBServiceFacade;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.data.NoteResult;

public class ProxyAccountSyncService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bankacct");
        selector.add("issync");
        selector.add("syndate");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        ArrayList<Long> syncPkIds = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            String beBankFunc = dataEntity.getDynamicObject("bankacct").getString("bebankfunc");
            if (beBankFunc != null && beBankFunc.contains("proxyinquiry")) {
                syncPkIds.add(dataEntity.getLong("id"));
                continue;
            }
            dataEntity.set("issync", (Object)"0");
            dataEntity.set("syndate", null);
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
        if (syncPkIds.size() > 0) {
            this.syncMappedAcctService(syncPkIds);
        }
    }

    private void syncMappedAcctService(List<Long> syncPkIds) {
        OperationResult operationResult = this.getOperationResult();
        IEBServiceFacade bankService = EBServiceFacadeFactory.getBankService();
        List<NoteResult> noteResults = bankService.syncMappedAcct(syncPkIds);
        ArrayList<Long> successBillIdList = new ArrayList<Long>(10);
        ArrayList<OperateErrorInfo> operateErrorInfoList = new ArrayList<OperateErrorInfo>(syncPkIds.size());
        if (noteResults != null && noteResults.size() != 0) {
            for (NoteResult noteResult : noteResults) {
                if (EBResultStatusCode.SUCCESS.equals((Object)noteResult.getStatusCode())) {
                    successBillIdList.add(noteResult.getBillId());
                    continue;
                }
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                operateErrorInfo.setLevel(ErrorLevel.Error);
                operateErrorInfo.setMessage(noteResult.getBillId() + ":" + noteResult.getErrMsg());
                operateErrorInfoList.add(operateErrorInfo);
                operationResult.setAllErrorInfo(operateErrorInfoList);
            }
        }
        operationResult.setSuccessPkIds(successBillIdList);
    }
}

