/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.opservice.schedule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.service.pa.util.StringUtil;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankJournalDownSchService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(BankJournalDownSchService.class);
    private static final String ACCOUNT_BANK_ID = "id";
    private static final String EXECUTE_PERIOD = "schedule_cycle";

    public List<String> getSelector() {
        ArrayList<String> lst = new ArrayList<String>();
        lst.add("company");
        lst.add("bankaccountnumber");
        return lst;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        String cycle = (String)this.operationVariable.get(EXECUTE_PERIOD);
        int scheduleCycle = 1;
        if (StringUtil.isNotEmpty((String)cycle)) {
            scheduleCycle = Integer.parseInt(cycle);
        }
        List accBankIds = Arrays.stream(dataEntities).filter(data -> EmptyUtil.isNoEmpty((DynamicObject)data)).map(data -> data.getLong(ACCOUNT_BANK_ID)).collect(Collectors.toList());
        logger.info(String.format("BankJournalDownSchService::Receives parameter by intelligent scheduling: schedule_cycle:%s, size of accBankIds:%s", cycle, accBankIds.size()));
        DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"downloadbankjournal", (String)"download", (Object[])new Object[]{accBankIds, scheduleCycle});
    }
}

