/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.service.integration;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.am.business.service.integration.lib.AbstractTransfer;
import kd.tmc.fbp.common.enums.BankFuncEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankAccountTransfer
extends AbstractTransfer {
    private static final String[] bankFunc = new String[]{BankFuncEnum.QUERY.getValue(), BankFuncEnum.PAY.getValue(), BankFuncEnum.RECEIPT.getValue(), BankFuncEnum.ECD.getValue(), BankFuncEnum.PROXYINQUIRY.getValue()};

    @Override
    public String getTargetObjName() {
        return "am_accountbank";
    }

    @Override
    public void transfer(DynamicObject targetObj, Map<String, Object> param) {
        Object number = param.get("number");
        if (EmptyUtil.isEmpty((Object)number)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"BankAccountTransfer_0", (String)"tmc-am-business", (Object[])new Object[0]));
        }
        targetObj.set("number", number);
        targetObj.set("name", param.get("name"));
        targetObj.set("status", param.get("status"));
        targetObj.set("enable", param.get("enable"));
        targetObj.set("createtime", (Object)this.strToDate((String)param.get("createtime")));
        targetObj.set("modifytime", (Object)this.strToDate((String)param.get("modifytime")));
        targetObj.set("masterid", targetObj.getPkValue());
        DynamicObject createOrg = BusinessDataServiceHelper.loadSingle((Object)param.get("createorg"), (String)"bos_org");
        targetObj.set("createorg", (Object)createOrg);
        DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)param.get("org"), (String)"bos_org");
        targetObj.set("org", (Object)org);
        targetObj.set("ctrlstrategy", param.get("ctrlstrategy"));
        Object finOrgId = param.get("bank");
        if (finOrgId != null) {
            DynamicObject finOrg = TmcDataServiceHelper.loadSingle((Object)finOrgId, (String)"bd_finorginfo");
            targetObj.set("bank", (Object)finOrg);
            targetObj.set("finorgtype", finOrg.getDynamicObject("finorgtype").get("type"));
        }
        DynamicObject acctProperty = BusinessDataServiceHelper.loadSingle((Object)param.get("acctproperty"), (String)"bd_acctpurpose");
        targetObj.set("acctproperty", (Object)acctProperty);
        targetObj.set("opendate", (Object)this.strToDate((String)param.get("opendate")));
        targetObj.set("shortnumber", param.get("shortnumber"));
        targetObj.set("acctstatus", param.get("acctstatus"));
        targetObj.set("isdefaultpay", param.get("isdefaultpay"));
        targetObj.set("issetbankinterface", param.get("issetbankinterface"));
        targetObj.set("closedate", (Object)this.strToDate((String)param.get("closedate")));
        DynamicObject defaultCurrency = BusinessDataServiceHelper.loadSingle((Object)param.get("defaultcurrency"), (String)"bd_currency");
        targetObj.set("defaultcurrency", (Object)defaultCurrency);
        targetObj.set("currency", (Object)this.getCurrency());
        targetObj.set("acctstyle", param.get("acctstyle"));
        targetObj.set("accttype", param.get("accttype"));
        targetObj.set("bebankfunc", param.get("bebankfunc"));
        targetObj.set("managecurrency", param.get("managecurrency"));
        targetObj.set("acctname", param.get("acctname"));
        targetObj.set("comment", param.get("comment"));
        targetObj.set("closereason", param.get("closereason"));
        targetObj.set("acctmanageamt", param.get("acctmanageamt"));
        DynamicObject company = BusinessDataServiceHelper.loadSingle((Object)param.get("company"), (String)"bos_org");
        targetObj.set("company", (Object)company);
        DynamicObject openOrg = BusinessDataServiceHelper.loadSingle((Object)param.get("openorg"), (String)"bos_org");
        targetObj.set("openorg", (Object)openOrg);
        targetObj.set("ismulcurrency", param.get("ismulcurrency"));
        targetObj.set("bankaccountnumber", param.get("bankaccountnumber"));
        targetObj.set("currencyname", param.get("currencyname"));
        Object strategy = param.get("strategy");
        if (strategy != null) {
            DynamicObject strategyDo = BusinessDataServiceHelper.loadSingle((Object)param.get("strategy"), (String)"am_strategy");
            targetObj.set("strategy", (Object)strategyDo);
        }
        this.handleBankFunction();
    }

    private DynamicObjectCollection getCurrency() {
        Object currencyId = this.param.get("currency");
        if (currencyId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a", (String)"BankAccountTransfer_1", (String)"tmc-am-business", (Object[])new Object[0]));
        }
        DynamicObject currency = TmcDataServiceHelper.loadSingle(currencyId, (String)"bd_currency");
        return TmcDataServiceHelper.generateMultiPropValue((DynamicObject)this.targetObj, (String)"currency", (DynamicObject[])new DynamicObject[]{currency});
    }

    private void handleBankFunction() {
        DynamicObjectCollection entries = this.targetObj.getDynamicObjectCollection("entry");
        if (this.targetObj.getBoolean("issetbankinterface")) {
            String bankFunction = this.targetObj.getString("bebankfunc");
            if (entries.isEmpty()) {
                for (int i = 0; i < 5; ++i) {
                    DynamicObject entry = entries.addNew();
                    entry.set("e_bankfunction", (Object)bankFunc[i]);
                    entry.set("seq", (Object)(i + 1));
                    entry.set("e_enable", (Object)(StringUtils.isNotBlank((CharSequence)bankFunction) && bankFunction.contains(bankFunc[i]) ? 1 : 0));
                }
            } else {
                for (DynamicObject entry : entries) {
                    entry.set("e_enable", (Object)(StringUtils.isNotBlank((CharSequence)bankFunction) && bankFunction.contains(entry.getString("e_bankfunction")) ? 1 : 0));
                }
            }
        } else {
            entries.clear();
        }
    }
}

