/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.service.integration;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.am.business.service.integration.BankCateHelper;
import kd.tmc.am.business.service.integration.lib.AbstractTransfer;
import kd.tmc.am.common.helper.CountryHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinOrgTransfer
extends AbstractTransfer {
    @Override
    public String getTargetObjName() {
        return "bd_finorginfo";
    }

    @Override
    public void transfer(DynamicObject targetObj, Map<String, Object> param) {
        String finOrgType = this.handleFinOrgType();
        this.handleBasicInfo();
        this.handleAdminDivision();
        this.handleTreeInfo(finOrgType);
        if ("0".equals(finOrgType)) {
            this.handleBankCategory();
        } else {
            targetObj.set("bank_cate", null);
        }
        if ("1".equals(finOrgType) || "3".equals(finOrgType)) {
            this.handleOrg();
        } else {
            targetObj.set("org", null);
        }
    }

    private String handleFinOrgType() {
        boolean isBank = (Boolean)this.param.get("isBank");
        boolean isFinanceCompany = (Boolean)this.param.get("isFinanceCompany");
        boolean isInGroup = (Boolean)this.param.get("inGroup");
        String finOrgType = isInGroup ? "1" : (isFinanceCompany ? "3" : (isBank ? "0" : "11"));
        DynamicObject finOrgTypeObj = TmcDataServiceHelper.loadSingle((String)"bd_finorgtype", (String)"id", (QFilter[])new QFilter[]{new QFilter("type", "=", (Object)finOrgType)});
        this.targetObj.set("finorgtype", (Object)finOrgTypeObj);
        return finOrgType;
    }

    private void handleBasicInfo() {
        this.targetObj.set("number", this.param.get("number"));
        this.targetObj.set("name", (Object)this.getValueZhCN((Map)this.param.get("name")));
        this.targetObj.set("createtime", (Object)this.strToDate((String)this.param.get("createtime")));
        this.targetObj.set("modifytime", (Object)this.strToDate((String)this.param.get("modifytime")));
        this.targetObj.set("comment", this.param.get("comment"));
        this.targetObj.set("union_number", this.param.get("union_number"));
        this.targetObj.set("address", this.param.get("address"));
        this.targetObj.set("contact_man", this.param.get("contact_man"));
        this.targetObj.set("telephone", this.param.get("telephone"));
        this.targetObj.set("fax", this.param.get("fax"));
        this.targetObj.set("status", (Object)BillStatusEnum.AUDIT.getValue());
        this.targetObj.set("masterid", this.targetObj.getPkValue());
        boolean inGroup = (Boolean)this.param.get("inGroup");
        boolean enable = Boolean.parseBoolean((String)this.param.get("enable"));
        if (!inGroup && enable) {
            this.targetObj.set("enable_time", (Object)this.strToDate((String)this.param.get("createtime")));
        } else if (inGroup && enable) {
            this.targetObj.set("enable_time", (Object)this.strToDate((String)this.param.get("enable_time")));
        }
        this.targetObj.set("enable", (Object)(enable ? "1" : "0"));
    }

    private void handleAdminDivision() {
        String unionNumber = (String)this.param.get("union_number");
        boolean isHandle = false;
        if (EmptyUtil.isNotEmpty((CharSequence)unionNumber)) {
            DynamicObject beBank = TmcDataServiceHelper.loadSingle((String)"bd_bebank", (String)String.join((CharSequence)",", "country", "province", "city"), (QFilter[])new QFilter[]{new QFilter("union_number", "=", (Object)unionNumber)});
            if (beBank != null) {
                DynamicObject county = beBank.getDynamicObject("country");
                DynamicObject province = beBank.getDynamicObject("province");
                DynamicObject city = beBank.getDynamicObject("city");
                this.targetObj.set("country", (Object)county);
                this.targetObj.set("province", (Object)province);
                this.targetObj.set("city", (Object)city);
                this.targetObj.set("bebank", (Object)beBank);
                isHandle = true;
            } else {
                this.targetObj.set("country", null);
                this.targetObj.set("province", null);
                this.targetObj.set("city", null);
                this.targetObj.set("bebank", null);
            }
        }
        if (!isHandle) {
            Object areaType = this.param.get("bankAreaType");
            if (Integer.valueOf(1).equals(areaType)) {
                DynamicObject china = TmcDataServiceHelper.loadSingleFromCache((String)"bd_country", (String)"id", (QFilter[])new QFilter[]{CountryHelper.getChinaFilter()});
                this.targetObj.set("country", (Object)china);
            } else {
                this.targetObj.set("country", null);
            }
            this.targetObj.set("province", null);
            this.targetObj.set("city", null);
            this.targetObj.set("bebank", null);
        }
    }

    private void handleBankCategory() {
        String topName;
        String unionNumber = (String)this.param.get("union_number");
        Object bankCate = null;
        if (EmptyUtil.isNotEmpty((CharSequence)unionNumber) && !"null".equals(unionNumber)) {
            String bankName = (String)this.param.get("bankName");
            bankCate = BankCateHelper.findBankCate(bankName, unionNumber);
        }
        if (bankCate == null && (bankCate = TmcDataServiceHelper.loadSingle((String)"bd_bankcgsetting", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)(topName = (String)this.param.get("topName")))})) == null) {
            bankCate = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_bankcgsetting"));
            bankCate.set("name", (Object)topName);
            bankCate.set("enable", (Object)1);
            bankCate.set("status", (Object)BillStatusEnum.AUDIT.getValue());
            bankCate.set("enable_time", (Object)new Date());
            OperationResult result = TmcOperateServiceHelper.execOperate((String)"save", (String)"bd_bankcgsetting", (DynamicObject[])new DynamicObject[]{bankCate}, (OperateOption)OperateOption.create());
            bankCate = result.getSuccessPkIds().size() > 0 ? TmcDataServiceHelper.loadSingle(result.getSuccessPkIds().get(0), (String)"bd_bankcgsetting") : null;
        }
        this.targetObj.set("bank_cate", bankCate);
    }

    private void handleOrg() {
        Object orgId = this.param.get("org");
        if (orgId != null) {
            DynamicObject org = TmcDataServiceHelper.loadSingle(orgId, (String)"bos_org");
            this.targetObj.set("org", (Object)org);
        }
    }

    private void handleTreeInfo(String finOrgType) {
        if ("0".equals(finOrgType)) {
            this.targetObj.set("level", (Object)1);
            this.targetObj.set("is_leaf", (Object)1);
            this.targetObj.set("parent", null);
            this.targetObj.set("longnumber", this.param.get("number"));
        } else {
            String longNumber = (String)this.param.get("longnumber");
            this.targetObj.set("longnumber", this.param.get("longnumber"));
            if (EmptyUtil.isEmpty((String)longNumber)) {
                return;
            }
            String[] longNumberArr = longNumber.split("!");
            LinkedList<String> longNumberQueue = new LinkedList<String>(Arrays.asList(longNumberArr));
            Collections.reverse(longNumberQueue);
            longNumberQueue.removeFirst();
            this.targetObj.set("parent", (Object)this.createParent(longNumberQueue));
            int level = longNumberArr.length;
            this.targetObj.set("level", (Object)level);
            this.targetObj.set("is_leaf", this.param.get("is_leaf"));
        }
    }

    private DynamicObject createParent(LinkedList<String> longNumberQueue) {
        if (longNumberQueue.size() == 0) {
            return null;
        }
        String number = longNumberQueue.poll();
        DynamicObject finOrg = TmcDataServiceHelper.loadSingle((String)"bd_finorginfo", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
        if (finOrg == null) {
            finOrg = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_finorginfo"));
            finOrg.set("number", (Object)number);
            finOrg.set("parent", (Object)this.createParent(longNumberQueue));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finOrg});
        }
        return finOrg;
    }
}

