/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.service.upgrade;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.am.common.helper.BankFunctionHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.constant.RpcResult;
import kd.tmc.fbp.common.constant.RpcResultStatusCode;
import kd.tmc.fbp.common.enums.BankFuncEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class BankFunkListUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(BankFunkListUpgradeService.class);
    private static final String CLEAR_SQL = "delete from t_am_bankfunclist";

    public String upgrade() {
        LOGGER.info("BankFunkListUpgradeService_upgrade_begin");
        String[] bankFunc = new String[]{BankFuncEnum.QUERY.getValue(), BankFuncEnum.PAY.getValue(), BankFuncEnum.RECEIPT.getValue(), BankFuncEnum.ECD.getValue(), BankFuncEnum.PROXYINQUIRY.getValue()};
        RpcResult result = new RpcResult();
        DB.execute((DBRoute)DBRouteConst.BASE, (String)CLEAR_SQL);
        QFilter qFilter = new QFilter("issetbankinterface", "=", (Object)true);
        DynamicObject[] bankAccounts = TmcDataServiceHelper.load((String)"am_accountbank", (String)"id,opendate,bebankfunc,entry,entry.seq,entry.e_bankfunction,entry.e_enable,entry.e_predictopendate", (QFilter[])new QFilter[]{qFilter});
        if (bankAccounts == null || bankAccounts.length == 0) {
            return JSON.toJSONString((Object)result);
        }
        for (DynamicObject bankAccount : bankAccounts) {
            String bebankfunc = bankAccount.getString("bebankfunc");
            Date openDate = bankAccount.getDate("opendate");
            DynamicObjectCollection entries = bankAccount.getDynamicObjectCollection("entry");
            if (entries == null || !entries.isEmpty()) continue;
            for (int i = 0; i < 5; ++i) {
                DynamicObject entry = entries.addNew();
                entry.set("e_bankfunction", (Object)bankFunc[i]);
                entry.set("seq", (Object)(i + 1));
                entry.set("e_enable", (Object)Character.valueOf('0'));
                if (!StringUtils.isNotBlank((CharSequence)bebankfunc) || !bebankfunc.contains(bankFunc[i])) continue;
                entry.set("e_enable", (Object)Character.valueOf('1'));
                entry.set("e_predictopendate", (Object)openDate);
            }
        }
        try (TXHandle h = TX.requiresNew((String)"BankFunkListUpgradeService.upgrade.save");){
            try {
                SaveServiceHelper.save((DynamicObject[])bankAccounts);
            }
            catch (Exception e) {
                result.setStatusCode(RpcResultStatusCode.ERROR);
                result.setMessage(e.getMessage());
                LOGGER.error("BankFunkListUpgradeService.upgrade.save", (Throwable)e);
                h.markRollback();
            }
        }
        QFilter qFilter1 = new QFilter("issetbankinterface", "=", (Object)true);
        QFilter qFilter2 = new QFilter("entry.e_enable", "=", (Object)true);
        BankFunctionHelper.upgrade(Arrays.asList(qFilter1, qFilter2));
        return JSON.toJSONString((Object)result);
    }
}

