/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.service.upgrade;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.constant.RpcResult;
import kd.tmc.fbp.common.constant.RpcResultStatusCode;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class InnerAcctUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(InnerAcctUpgradeService.class);

    public String upgrade() {
        RpcResult result = new RpcResult();
        DynamicObject[] accts = null;
        try {
            QFilter qFilter = new QFilter("finorgtype", "=", (Object)"1");
            qFilter.and(new QFilter("inneracct.id", ">", (Object)0));
            ArrayList<QFilter> qf = new ArrayList<QFilter>(10);
            qf.add(qFilter);
            accts = TmcDataServiceHelper.load((String)"am_accountbank", (String)"id, finorgtype, bank, inneracct, acctclassify, scorg", (QFilter[])qf.toArray(new QFilter[qf.size()]));
            if (accts == null || accts.length == 0) {
                return JSON.toJSONString((Object)result);
            }
            HashMap<Long, DynamicObject> idMap = new HashMap<Long, DynamicObject>(10);
            for (DynamicObject acct : accts) {
                DynamicObject scOrg;
                DynamicObject bk = acct.getDynamicObject("bank");
                Long bkId = (Long)bk.get("id");
                DynamicObject bkInfo = (DynamicObject)idMap.get(bkId);
                if (bkInfo == null) {
                    bkInfo = TmcDataServiceHelper.loadSingle((Object)bkId, (String)"bd_finorginfo");
                    idMap.put(bkId, bkInfo);
                }
                if (bkInfo == null || (scOrg = (DynamicObject)bkInfo.get("org")) == null) continue;
                acct.set("acctclassify", (Object)"I");
                acct.set("scorg", scOrg.get("id"));
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            result.setStatusCode(RpcResultStatusCode.ERROR);
            result.setMessage(e.getMessage());
            return JSON.toJSONString((Object)result);
        }
        try (TXHandle h = TX.requiresNew((String)"InnerAcctUpgradeService.upgrade.save");){
            try {
                SaveServiceHelper.save((DynamicObject[])accts);
            }
            catch (Exception e) {
                result.setStatusCode(RpcResultStatusCode.ERROR);
                result.setMessage(e.getMessage());
                LOGGER.error((Throwable)e);
                h.markRollback();
            }
        }
        return JSON.toJSONString((Object)result);
    }
}

