/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.task.restrictedfunds;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;

public class AutoLiftRestrictedFunds
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(AutoLiftRestrictedFunds.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.executeMethod();
    }

    private void executeMethod() {
        logger.info("\u5230\u671f\u81ea\u52a8\u89e3\u9664\u8d44\u91d1\u53d7\u9650\u5f00\u59cb...");
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(0);
        qFilterList.add(new QFilter("billstatus", "=", (Object)"C"));
        qFilterList.add(new QFilter("businesstype", "=", (Object)"1"));
        qFilterList.add(new QFilter("isautolift", "=", (Object)"1"));
        Date today = new Date();
        qFilterList.add(new QFilter("estimatedliftdate", "<=", (Object)DateUtils.getDataFormat((Date)today, (boolean)false)));
        qFilterList.add(new QFilter("estimatedliftdate", ">=", (Object)DateUtils.getDataFormat((Date)today, (boolean)true)));
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"am_restrictedfundsmanager", (String)"id,unrestrictedamt,isallrestricted,actualliftdate", (QFilter[])qFilterList.toArray(new QFilter[0]));
        if (bills != null && bills.size() > 0) {
            ArrayList<Long> billIds = new ArrayList<Long>(2);
            for (DynamicObject bill : bills) {
                BigDecimal unRestrictedAmt = bill.getBigDecimal("unrestrictedamt");
                long billId = bill.getLong("id");
                boolean isAllRestricted = bill.getBoolean("isallrestricted");
                Date actualLiftDate = bill.getDate("actualliftdate");
                if (isAllRestricted && actualLiftDate == null) {
                    billIds.add(billId);
                    continue;
                }
                if (unRestrictedAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
                billIds.add(billId);
            }
            OperateOption option = OperateOption.create();
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"pushandsave", (String)"am_restrictedfundsmanager", (Object[])billIds.toArray(), (OperateOption)option);
            if (!operationResult.isSuccess()) {
                logger.info(operationResult.getMessage());
            }
        }
        logger.info("\u5230\u671f\u81ea\u52a8\u89e3\u9664\u8d44\u91d1\u53d7\u9650\u7ed3\u675f...");
    }
}

