/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.upgrade;

import com.alibaba.fastjson.JSON;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.tmc.fbp.common.constant.RpcResult;
import kd.tmc.fbp.common.constant.RpcResultStatusCode;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class AcctNameUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(AcctNameUpgradeService.class);

    public String upgrade() {
        RpcResult result = new RpcResult();
        QFilter filter = new QFilter("acctname", "is null", null).or(new QFilter("acctname", "=", (Object)Character.valueOf(' ')));
        DynamicObject[] bankAccounts = TmcDataServiceHelper.load((String)"am_accountbank", (String)"acctname, openorg", (QFilter[])filter.toArray());
        if (bankAccounts == null || bankAccounts.length == 0) {
            return JSON.toJSONString((Object)result);
        }
        for (DynamicObject bankAccount : bankAccounts) {
            String acctName = bankAccount.getString("acctname");
            DynamicObject openOrg = bankAccount.getDynamicObject("openorg");
            if (!StringUtils.isBlank((String)acctName) || Objects.isNull(openOrg)) continue;
            bankAccount.set("acctname", openOrg.get("name"));
        }
        try (TXHandle h = TX.requiresNew((String)"AcctNameUpgradeService.upgrade.save");){
            try {
                SaveServiceHelper.save((DynamicObject[])bankAccounts);
            }
            catch (Exception e) {
                result.setStatusCode(RpcResultStatusCode.ERROR);
                result.setMessage(e.getMessage());
                LOGGER.error((Throwable)e);
                h.markRollback();
            }
        }
        return JSON.toJSONString((Object)result);
    }
}

