/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.validate.bankacct;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.am.common.errorcode.BankAcctErrorCode;
import kd.tmc.am.common.exception.AmException;
import kd.tmc.am.common.helper.AmParameterHelper;
import kd.tmc.am.common.helper.BankAcctHelper;
import kd.tmc.am.common.resource.BankAcctBizResource;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.enums.TmcParamEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;

public class BankAccountChangeValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("createorg");
        selector.add("company");
        selector.add("acctstatus");
        selector.add("finorgtype");
        selector.add("acctstyle");
        selector.add("bankaccountnumber");
        selector.add("acctclassify");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        Map<Long, List<ExtendedDataEntity>> companyMaps = Arrays.stream(this.dataEntities).collect(Collectors.groupingBy(o -> o.getDataEntity().getDynamicObject("company").getLong("id")));
        if (companyMaps.size() > 1) {
            throw new AmException(new BankAcctErrorCode().NOT_SUPPORT_BATCH());
        }
        for (Map.Entry<Long, List<ExtendedDataEntity>> companyMap : companyMaps.entrySet()) {
            boolean isChangeApplyParam = AmParameterHelper.getAppBoolParameter((long)companyMap.getKey(), (String)TmcParamEnum.AM003.getValue());
            if (isChangeApplyParam || companyMap.getValue().size() <= 1) continue;
            throw new AmException(new BankAcctErrorCode().BATCH_COMPANY_NO_PARAM(companyMap.getValue().get(0).getDataEntity().getString("bankaccountnumber"), companyMap.getValue().get(0).getDataEntity().getDynamicObject("company").getString("name")));
        }
        Map<Object, List<DynamicObject>> acctClassifyMap = Arrays.stream(this.dataEntities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.groupingBy(o -> o.getString("acctclassify")));
        if (acctClassifyMap.size() > 1 || acctClassifyMap.get("I") != null && acctClassifyMap.get("I").size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5185\u90e8\u8d26\u6237\u4e0d\u652f\u6301\u6279\u91cf\u53d8\u66f4\u3002", (String)"BankAccountChangeValidator_3", (String)"tmc-am-business", (Object[])new Object[0]));
        }
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject bankAcct = extendedDataEntity.getDataEntity();
            boolean isChangeApply = AmParameterHelper.getAppBoolParameter((long)bankAcct.getDynamicObject("company").getLong("id"), (String)TmcParamEnum.AM003.getValue());
            QFilter[] filters = new QFilter[]{new QFilter("accountbank", "=", bankAcct.getPkValue()), new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()), new QFilter("billstatus", "!=", (Object)"E")};
            boolean isExists = QueryServiceHelper.exists((String)"am_changeapply", (QFilter[])filters);
            if (isChangeApply && isExists) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u8be5\u8d26\u6237\u5df2\u5b58\u5728\u5728\u9014\u53d8\u66f4\u5355\u636e", (String)"BankAccountChangeValidator_0", (String)"tmc-am-business", (Object[])new Object[0]), bankAcct.getString("bankaccountnumber")));
            }
            long userOrgId = RequestContext.get().getOrgId();
            List authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)TmcAppEnum.AM.getId(), (String)bankAcct.getDataEntityType().getName(), (String)"47150e89000000ac");
            if (!authOrgIds.contains(bankAcct.getDynamicObject("createorg").getLong("id"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u4f7f\u7528\u6743\u7ec4\u7ec7\u65e0\u6743\u9650\u5bf9\u5206\u914d\u7684\u8d26\u6237\u505a\u53d8\u66f4\u64cd\u4f5c\u3002", (String)"BankAccountChangeValidator_1", (String)"tmc-am-business", (Object[])new Object[0]), bankAcct.getString("bankaccountnumber")));
            }
            String acctStatus = bankAcct.getString("acctstatus");
            if ("freeze".equals(acctStatus) || "closed".equals(acctStatus) || "closing".equals(acctStatus)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u51bb\u7ed3\u3001\u9500\u6237\u4e2d\u3001\u5df2\u9500\u6237\u72b6\u6001\u7684\u94f6\u884c\u8d26\u6237\u65e0\u6cd5\u53d1\u8d77\u53d8\u66f4\u7533\u8bf7", (String)"BankAccountChangeValidator_2", (String)"tmc-am-business", (Object[])new Object[0]), bankAcct.getString("bankaccountnumber")));
            }
            String acctStyle = bankAcct.getString("acctstyle");
            boolean isExistBasicAccount = BankAcctHelper.isExistBasicAccount((Object)bankAcct.getDynamicObject("company").getLong("id"), (Object)bankAcct.getLong("id"));
            boolean isCheckOneBasic = AmParameterHelper.getAppBoolParameter((long)bankAcct.getDynamicObject("company").getLong("id"), (String)"ischeckonebasic");
            if (isCheckOneBasic && "basic".equals(acctStyle) && isExistBasicAccount) {
                throw new KDBizException(new BankAcctBizResource().getExistBasicAccount());
            }
            if (!BankAcctHelper.existUnAuditAccountManageTransfer((Object)bankAcct.getPkValue())) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"{0}\u94f6\u884c\u8d26\u6237\u7ba1\u7406\u6743\u8f6c\u8ba9\u4e2d\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u53d8\u66f4\u3002", (String)"BankAccountChangeValidator_01", (String)"tmc-am-business", (Object[])new Object[]{bankAcct.getString("bankaccountnumber")}));
        }
    }
}

