/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.validate.bankacct;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.am.common.enums.OpenAcctBillStatusEnum;
import kd.tmc.am.common.helper.AccountBankHelper;
import kd.tmc.am.common.helper.AmParameterHelper;
import kd.tmc.am.common.helper.BankAcctHelper;
import kd.tmc.am.common.resource.AmBizResource;
import kd.tmc.am.common.resource.BankAcctBizResource;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.enums.TmcParamEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.service.servicehlper.BankServiceHelper;

public class BankAccountSaveValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(BankAccountSaveValidator.class);

    public Set<String> preparePropertys() {
        Set selector = super.preparePropertys();
        selector.add("company");
        selector.add("opendate");
        selector.add("finorgtype");
        selector.add("bank");
        selector.add("currency");
        selector.add("defaultcurrency");
        selector.add("org");
        selector.add("bankaccountnumber");
        selector.add("ismulcurrency");
        selector.add("createorg");
        selector.add("acctstyle");
        selector.add("isdefaultpay");
        selector.add("isdefaultrec");
        selector.add("acctstatus");
        selector.add("closedatef");
        selector.add("issetbankinterface");
        selector.add("bebankfunc");
        selector.add("proxycurrency");
        selector.add("proxyinquiryaccount");
        selector.add("iselecpayment");
        selector.add("relatedsettleacct");
        return selector;
    }

    public void validate() {
        AmBizResource amBizResource = new AmBizResource();
        BankAcctBizResource resource = new BankAcctBizResource();
        Date currentDate = null;
        ExtendedDataEntity[] bankAcctEntities = this.getDataEntities();
        Map<Object, List<DynamicObject>> companyBasicMap = Arrays.stream(bankAcctEntities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.groupingBy(o -> o.getDynamicObject("company").getPkValue()));
        List banAcctIdList = Arrays.stream(bankAcctEntities).map(v -> v.getDataEntity().getPkValue()).collect(Collectors.toList());
        List orgIdList = Arrays.stream(bankAcctEntities).map(v -> v.getDataEntity().getDynamicObject("company").getPkValue()).collect(Collectors.toList());
        DynamicObject[] bankAcctsFromDB = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"company,isdefaultpay,isdefaultrec,bankaccountnumber", (QFilter[])new QFilter[]{new QFilter("id", "not in", banAcctIdList), new QFilter("company", "in", orgIdList), new QFilter("acctstatus", "!=", (Object)"closed")});
        Map<Object, Object> orgAcctMap = new HashMap(16);
        if (bankAcctsFromDB.length > 0) {
            orgAcctMap = Arrays.stream(bankAcctsFromDB).collect(Collectors.groupingBy(v -> v.getDynamicObject("company").getPkValue()));
        }
        DynamicObject[] bankAccts = BusinessDataServiceHelper.load((Object[])banAcctIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountbanks"));
        HashMap bankAcctFromDBMap = Arrays.stream(bankAccts).collect(Collectors.toMap(v -> v.getPkValue(), p -> p, (o1, o2) -> o1, HashMap::new));
        String operateKey = super.getOperateKey();
        for (ExtendedDataEntity dataEntity : bankAcctEntities) {
            boolean isCheck;
            List bankAcctFromDBs;
            DynamicObject bankObj;
            DynamicObject finorgtypeObj;
            DynamicObject bankAcctFromDB;
            DynamicObject bankAccount = dataEntity.getDataEntity();
            Object bankAcctId = bankAccount.getPkValue();
            Date openDate = bankAccount.getDate("opendate");
            Date closeDatef = bankAccount.getDate("closeDatef");
            DynamicObject company = bankAccount.getDynamicObject("company");
            if (company == null) continue;
            boolean elecPayment = bankAccount.getBoolean("iselecpayment");
            if (elecPayment) {
                Set acctSet = AccountBankHelper.getElecPaymentRelatedAcctIds((Long)bankAccount.getLong("id"));
                Set relatedSettleAcct = bankAccount.getDynamicObjectCollection("relatedsettleacct").stream().map(acct -> acct.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                for (Long id : relatedSettleAcct) {
                    if (!acctSet.contains(id)) continue;
                    DynamicObject settleAcct = QueryServiceHelper.queryOne((String)"am_accountbank", (String)"bankaccountnumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
                    this.addErrorMessage(dataEntity, amBizResource.getExistElecPaymentAcctUnClose(settleAcct.getString("bankaccountnumber")));
                }
            }
            boolean isCheckOneBasic = AmParameterHelper.getAppBoolParameter((long)company.getLong("id"), (String)"ischeckonebasic");
            List objectListEntry = companyBasicMap.get(bankAccount.getDynamicObject("company").getPkValue()).stream().filter(e -> !"closed".equals(e.getString("acctstatus"))).collect(Collectors.toList());
            Map<String, List<DynamicObject>> basicMap = objectListEntry.stream().filter(o -> "basic".equals(o.getString("acctstyle"))).collect(Collectors.groupingBy(o -> o.getString("acctstyle")));
            String status = bankAccount.getString("acctstatus");
            if (isCheckOneBasic && !"closed".equals(status) && "basic".equals(bankAccount.getString("acctstyle")) && basicMap.get("basic") != null && basicMap.get("basic").size() > 1) {
                this.addErrorMessage(dataEntity, resource.getExistBasicAccount2());
            }
            if (openDate != null && closeDatef != null && closeDatef.compareTo(openDate) <= 0) {
                this.addErrorMessage(dataEntity, amBizResource.getCloseDatefVal());
            }
            if ("importdata".equals(operateKey)) {
                try {
                    Map bankVersionMap;
                    String bankinterface = bankAccount.getString("bankinterface");
                    if (bankAccount.getBoolean("issetbankinterface") && StringUtils.isNotEmpty((CharSequence)bankinterface) && !(bankVersionMap = BankServiceHelper.getBankLoginId((DynamicObject)bankAccount)).containsKey(bankinterface)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u94f6\u4f01\u63a5\u53e3\u201d\u5339\u914d\u4e0d\u5230\u4e0b\u62c9\u9009\u9879", (String)"BankAccountSaveValidator_6", (String)"tmc-am-business", (Object[])new Object[0]));
                    }
                }
                catch (Exception e2) {
                    logger.info("\u521d\u59cb\u5316\u94f6\u884c\u63a5\u53e3\u4e0b\u62c9\u5217\u8868\u5f02\u5e38\u3002", (Object)e2);
                    this.addErrorMessage(dataEntity, e2.getMessage());
                }
            }
            QFilter isNewDataQFilter = new QFilter("id", "=", bankAcctId);
            boolean isExitsData = QueryServiceHelper.exists((String)"bd_accountbanks", (QFilter[])new QFilter[]{isNewDataQFilter});
            DynamicObject bankAccountDb = bankAccount;
            if (isExitsData) {
                bankAccountDb = BusinessDataServiceHelper.loadSingle((Object)bankAcctId, (String)"bd_accountbanks", (String)"createorg,finorgtype");
            }
            if (isExitsData) {
                boolean isChangeApply = AmParameterHelper.getAppBoolParameter((long)bankAccountDb.getDynamicObject("createorg").getLong("id"), (String)TmcParamEnum.AM003.getValue());
                String isFromChangeApply = this.getOption().getVariableValue("isfromchangeapply", "false");
                String finOrgType = bankAccountDb.getString("finorgtype");
                if (isChangeApply && !FinOrgTypeEnum.CLEARINGHOUSE.getValue().equals(finOrgType) && !"true".equals(isFromChangeApply)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u6237\u6240\u5c5e\u8d44\u91d1\u7ec4\u7ec7\u5f00\u542f\u3010\u94f6\u884c\u8d26\u6237\u5fc5\u987b\u901a\u8fc7\u53d8\u66f4\u6d41\u7a0b\u53d8\u66f4\u3011\u53c2\u6570\uff0c\u94f6\u884c\u8d26\u6237\u4fe1\u606f\u90fd\u5fc5\u987b\u901a\u8fc7\u53d8\u66f4\u6d41\u7a0b\u53d8\u66f4\uff0c\u4e0d\u5141\u8bb8\u76f4\u63a5\u4fee\u6539\u3002", (String)"BankAccountSaveValidator_1", (String)"tmc-am-business", (Object[])new Object[0]));
                }
            }
            if ((bankAcctFromDB = (DynamicObject)bankAcctFromDBMap.getOrDefault(bankAcctId, null)) != null && this.isCurrencyChange(bankAccount, bankAcctFromDB).booleanValue() && BankAcctHelper.isRefrenced((Object)bankAccount.getPkValue())) {
                this.addErrorMessage(dataEntity, resource.getCurrencyChangeError());
            }
            if (bankAcctFromDB != null && this.isCompanyChange(bankAccount, bankAcctFromDB).booleanValue() && BankAcctHelper.isRefrenced((Object)bankAccount.getPkValue())) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u5f53\u524d\u94f6\u884c\u8d26\u6237\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u80fd\u66f4\u6539\u7533\u8bf7\u516c\u53f8\u3002", (String)"BankAcctBizResource_09", (String)"tmc-am-common", (Object[])new Object[0]));
            }
            currentDate = new Date();
            if (null != openDate && currentDate.before(openDate)) {
                this.addErrorMessage(dataEntity, resource.getOpendateError());
            }
            DynamicObjectCollection currencys = bankAccount.getDynamicObjectCollection("currency");
            DynamicObject defCurrency = bankAccount.getDynamicObject("defaultcurrency");
            if (null == currencys) {
                this.addErrorMessage(dataEntity, resource.getCurrencyError());
            }
            if (null == defCurrency) {
                this.addErrorMessage(dataEntity, resource.getDefCurrError());
            }
            HashSet<Long> currencyIDs = new HashSet<Long>();
            for (DynamicObject prop : currencys) {
                currencyIDs.add((Long)((DataEntityBase)prop.get("fbasedataid")).getPkValue());
            }
            if (defCurrency != null && !currencyIDs.contains(defCurrency.getLong("id"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u9ed8\u8ba4\u5e01\u79cd\u201d\u4e0d\u5728\u5e01\u79cd\u8303\u56f4\u5185\u3002", (String)"BankAccountSaveValidator_4", (String)"tmc-am-business", (Object[])new Object[0]));
            }
            String finOrgType = bankAccount.getString("finorgtype");
            DynamicObject bank = bankAccount.getDynamicObject("bank");
            if (bank == null || (finorgtypeObj = (bankObj = BusinessDataServiceHelper.loadSingle((Object)bank.getPkValue(), (String)bank.getDynamicObjectType().getName())).getDynamicObject("finorgtype")) == null) continue;
            String bankFinOrgType = finorgtypeObj.getString("type");
            if (!StringUtils.equals((CharSequence)finOrgType, (CharSequence)bankFinOrgType)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u5f00\u6237\u884c\u201d\u6240\u5c5e\u91d1\u878d\u673a\u6784\u7c7b\u522b\u4e0e\u8d26\u6237\u91d1\u878d\u673a\u6784\u7c7b\u522b\u4e0d\u5339\u914d\u3002", (String)"BankAccountSaveValidator_5", (String)"tmc-am-business", (Object[])new Object[0]));
            }
            this.checkOpenApply(dataEntity, resource);
            DynamicObject capitalOrg = bankAccount.getDynamicObject("company");
            if (null == capitalOrg || CollectionUtils.isEmpty((Collection)(bankAcctFromDBs = (List)orgAcctMap.getOrDefault(capitalOrg.getPkValue(), null)))) continue;
            boolean isdefaultpayment = bankAccount.getBoolean("isdefaultpay");
            List defltPayAccts = bankAcctFromDBs.stream().filter(v -> v.getBoolean("isdefaultpay")).collect(Collectors.toList());
            if (isdefaultpayment && !CollectionUtils.isEmpty(defltPayAccts)) {
                this.addErrorMessage(dataEntity, String.format(resource.getMultioutacctError(), ((DynamicObject)defltPayAccts.get(0)).getString("bankaccountnumber")));
            }
            boolean isdefaultreck = bankAccount.getBoolean("isdefaultrec");
            List defltRecAccts = bankAcctFromDBs.stream().filter(v -> v.getBoolean("isdefaultrec")).collect(Collectors.toList());
            if (isdefaultreck && !CollectionUtils.isEmpty(defltRecAccts)) {
                this.addErrorMessage(dataEntity, String.format(resource.getMultiinacctError(), ((DynamicObject)defltRecAccts.get(0)).getString("bankaccountnumber")));
            }
            String acctStyle = bankAccount.getString("acctstyle");
            boolean isExistBasicAccount = BankAcctHelper.isExistBasicAccount((Object)capitalOrg.getLong("id"), (Object)bankAccount.getLong("id"));
            if (isCheckOneBasic && !"closed".equals(bankAccount.getString("acctstatus")) && "basic".equals(acctStyle) && isExistBasicAccount) {
                this.addErrorMessage(dataEntity, resource.getExistBasicAccount());
            }
            if (!(isCheck = this.checkProxyAccount(bankAccount))) {
                this.addErrorMessage(dataEntity, resource.getProxyAccountValidator());
                continue;
            }
            DynamicObject proxyCurrency = bankAccount.getDynamicObject("proxycurrency");
            if (proxyCurrency == null || currencyIDs.contains(proxyCurrency.getLong("id"))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u4ee3\u7406\u67e5\u8be2\u5e01\u79cd\u201d\u4e0d\u5728\u5e01\u79cd\u8303\u56f4\u5185\u3002", (String)"BankAccountSaveValidator_8", (String)"tmc-am-business", (Object[])new Object[0]));
        }
    }

    private boolean checkProxyAccount(DynamicObject bankAccount) {
        String beBankFunc;
        boolean isSetBankInterface;
        if (bankAccount != null && (isSetBankInterface = bankAccount.getBoolean("issetbankinterface")) && (beBankFunc = bankAccount.getString("bebankfunc")).contains("proxyinquiry")) {
            DynamicObject proxyCurrency = bankAccount.getDynamicObject("proxycurrency");
            String proxyInquiryAccount = bankAccount.getString("proxyinquiryaccount");
            if (EmptyUtil.isEmpty((DynamicObject)proxyCurrency) && EmptyUtil.isNoEmpty((String)proxyInquiryAccount) || EmptyUtil.isNoEmpty((DynamicObject)proxyCurrency) && EmptyUtil.isEmpty((String)proxyInquiryAccount)) {
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    private void checkOpenApply(ExtendedDataEntity dataEntity, BankAcctBizResource resource) {
        String billNo;
        DynamicObject bankAccount = dataEntity.getDataEntity();
        QFilter qFilter = new QFilter("bankaccountnumber", "=", bankAccount.get("bankaccountnumber"));
        QFilter openAcctStatusFilter = new QFilter("billstatus", "=", (Object)OpenAcctBillStatusEnum.R.getValue());
        long sourceBillId = bankAccount.getLong("sourcebillid");
        if (sourceBillId > 0L) {
            logger.info("\u6765\u81ea\u5f00\u6237\u7533\u8bf7\u3002sourceBillId = {}", (Object)sourceBillId);
            QFilter pkFilter = new QFilter("id", "!=", (Object)sourceBillId);
            openAcctStatusFilter.and(pkFilter);
        } else {
            logger.info("\u975e\u5f00\u6237\u7533\u8bf7\u4e0b\u63a8\u3002");
        }
        DynamicObject[] openAppliesByNumber = TmcDataServiceHelper.load((String)"am_accopenbill", (String)"id,billno", (QFilter[])new QFilter[]{qFilter, openAcctStatusFilter});
        if (openAppliesByNumber.length > 0) {
            String billNo2 = openAppliesByNumber[0].getString("billno");
            this.addErrorMessage(dataEntity, resource.getExistRepeatNumber(billNo2));
        }
        QFilter orgFilter = new QFilter("company", "=", bankAccount.getDynamicObject("company").getPkValue());
        if ("1".equals(bankAccount.getString("isdefaultpay"))) {
            QFilter payFilter = new QFilter("isdefaultpay", "=", (Object)"1");
            DynamicObject[] openAppliesByPay = TmcDataServiceHelper.load((String)"am_accopenbill", (String)"id,billno", (QFilter[])new QFilter[]{orgFilter, openAcctStatusFilter, payFilter});
            if (openAppliesByPay.length > 0) {
                billNo = openAppliesByPay[0].getString("billno");
                this.addErrorMessage(dataEntity, resource.getExistDefaultPay(billNo));
            }
        }
        if ("1".equals(bankAccount.getString("isdefaultrec"))) {
            QFilter treckFilter = new QFilter("isdefaultrec", "=", (Object)"1");
            DynamicObject[] openApplies = TmcDataServiceHelper.load((String)"am_accopenbill", (String)"id,billno", (QFilter[])new QFilter[]{orgFilter, openAcctStatusFilter, treckFilter});
            if (openApplies.length > 0) {
                billNo = openApplies[0].getString("billno");
                this.addErrorMessage(dataEntity, resource.getExistDefaultRec(billNo));
            }
        }
    }

    private Boolean isCurrencyChange(DynamicObject bankAcct, DynamicObject bankAcctFromDB) {
        DynamicObjectCollection currency = bankAcct.getDynamicObjectCollection("currency");
        DynamicObjectCollection currencysFromDB = bankAcctFromDB.getDynamicObjectCollection("currency");
        List currencyList = currency.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
        for (DynamicObject currencyFromDB : currencysFromDB) {
            if (currencyList.contains(currencyFromDB.getDynamicObject("fbasedataid").getPkValue())) continue;
            return true;
        }
        return false;
    }

    private Boolean isCompanyChange(DynamicObject bankAcct, DynamicObject bankAcctFromDB) {
        Long companyFromDBID;
        DynamicObject company = bankAcct.getDynamicObject("company");
        DynamicObject companyFromDB = bankAcctFromDB.getDynamicObject("company");
        Long companyID = company.getLong("id");
        if (companyID.compareTo(companyFromDBID = Long.valueOf(companyFromDB.getLong("id"))) != 0) {
            return true;
        }
        return false;
    }
}

