/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.validate.bankacct;

import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.am.common.helper.BankAcctHelper;
import kd.tmc.am.common.resource.AmBizResource;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankAcctAssignValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("createorg");
        selector.add("finorgtype");
        selector.add("bankaccountnumber");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntitys) throws KDBizException {
        AmBizResource resource = new AmBizResource();
        String createOrg = this.getOption().getVariableValue("createOrg");
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntitys) {
            DynamicObject bankAcct = extendedDataEntity.getDataEntity();
            if (!EmptyUtil.isEmpty((String)createOrg) && !createOrg.equals(bankAcct.getDynamicObject("createorg").getString("id"))) {
                this.addErrorMessage(extendedDataEntity, resource.getUnAllowAssign());
            }
            if (Objects.equals(bankAcct.get("finorgtype"), FinOrgTypeEnum.CLEARINGHOUSE.getValue())) {
                this.addErrorMessage(extendedDataEntity, resource.getClearingHouseAssign());
            }
            if (!BankAcctHelper.existUnAuditAccountManageTransfer((Object)bankAcct.getPkValue())) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"{0}\u94f6\u884c\u8d26\u6237\u7ba1\u7406\u6743\u8f6c\u8ba9\u4e2d\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u5206\u914d\u3002", (String)"BankAcctAssignValidator_01", (String)"tmc-am-business", (Object[])new Object[]{bankAcct.getString("bankaccountnumber")}));
        }
    }
}

