/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.validate.bankacct;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.am.common.helper.AmParameterHelper;
import kd.tmc.am.common.helper.BankAcctHelper;
import kd.tmc.am.common.resource.AmBizResource;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.TmcParamEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankAcctDeleteValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        super.getSelector();
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("company");
        sic.add("finorgtype");
        sic.add("bank");
        sic.add("bankaccountnumber");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        Map variables = this.getOption().getVariables();
        String isNeedValidate = (String)variables.get("isneedvalidate");
        if (Objects.equals(isNeedValidate, String.valueOf(false))) {
            return;
        }
        AmBizResource amBizResource = new AmBizResource();
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bank;
            DynamicObject org;
            DynamicObject bankAcct = data.getDataEntity();
            DynamicObject company = bankAcct.getDynamicObject("company");
            String isOpenByProcess = AmParameterHelper.getAppStringParameter((long)company.getLong("id"), (String)TmcParamEnum.AM001.getValue());
            if ("1".equals(isOpenByProcess)) {
                this.addErrorMessage(data, amBizResource.getDeleteOrgError());
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(org = (bank = TmcDataServiceHelper.loadSingle((Object)bankAcct.getDynamicObject("bank").getPkValue(), (String)"bd_finorginfo", (String)"org")).getDynamicObject("org")))) {
                this.addErrorMessage(data, amBizResource.getDeleteAcctError());
            }
            if (!BankAcctHelper.existUnAuditAccountManageTransfer((Object)bankAcct.getPkValue())) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"{0}\u94f6\u884c\u8d26\u6237\u7ba1\u7406\u6743\u8f6c\u8ba9\u4e2d\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u5220\u9664\u3002", (String)"BankAcctDeleteValidator_01", (String)"tmc-am-business", (Object[])new Object[]{bankAcct.getString("bankaccountnumber")}));
        }
    }
}

