/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.validate.bankacct;

import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.am.common.enums.AcctClassifyEnum;
import kd.tmc.am.common.helper.BankAcctHelper;
import kd.tmc.am.common.resource.AmBizResource;
import kd.tmc.am.common.resource.BankAcctBizResource;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankAcctFreezeValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("acctstatus");
        selector.add("acctclassify");
        selector.add("bankaccountnumber");
        selector.add("createorg");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        AmBizResource resource = new AmBizResource();
        String createOrg = this.getOption().getVariableValue("createOrg");
        this.getOption();
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            String acctStatus;
            DynamicObject bankAcct = extendedDataEntity.getDataEntity();
            if (!EmptyUtil.isEmpty((String)createOrg) && !createOrg.equals(bankAcct.getDynamicObject("createorg").getString("id"))) {
                this.addErrorMessage(extendedDataEntity, resource.getUnAllowFreezeAssign());
            }
            if (Objects.equals(bankAcct.get("acctclassify"), AcctClassifyEnum.INNER_ACCOUNT.getValue())) {
                this.addErrorMessage(extendedDataEntity, resource.getUnAllowFreeze());
            }
            if (!(acctStatus = bankAcct.getString("acctstatus")).equals(BankAcctStatusEnum.NORMAL.getValue())) {
                this.addErrorMessage(extendedDataEntity, String.format(resource.getFreezeAcctStatusError(), BankAcctStatusEnum.getName((String)acctStatus)));
            }
            QFilter acctCloseFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
            acctCloseFilter.and(new QFilter("accountbank", "=", bankAcct.getPkValue()));
            boolean isExistAcctCloseBill = TmcDataServiceHelper.exists((String)"am_acctclosebill", (QFilter[])new QFilter[]{acctCloseFilter});
            if (isExistAcctCloseBill) {
                this.addErrorMessage(extendedDataEntity, new BankAcctBizResource().getExistAcctCloseBill(bankAcct.getString("bankaccountnumber")));
            }
            QFilter acctChangeApplyFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
            acctChangeApplyFilter.and(new QFilter("entryentity2.e_accountbank", "=", bankAcct.getPkValue()));
            boolean isExitsChangeApplyBill = QueryServiceHelper.exists((String)"am_changeapply", (QFilter[])new QFilter[]{acctChangeApplyFilter});
            if (isExitsChangeApplyBill) {
                this.addErrorMessage(extendedDataEntity, new BankAcctBizResource().getExistChangeApplyBill(bankAcct.getString("bankaccountnumber")));
            }
            if (!BankAcctHelper.existUnAuditAccountManageTransfer((Object)bankAcct.getPkValue())) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"{0}\u94f6\u884c\u8d26\u6237\u7ba1\u7406\u6743\u8f6c\u8ba9\u4e2d\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u51bb\u7ed3\u3002", (String)"BankAcctFreezeValidator_01", (String)"tmc-am-business", (Object[])new Object[]{bankAcct.getString("bankaccountnumber")}));
        }
    }
}

