/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.validate.bankacct;

import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.am.common.helper.AmParameterHelper;
import kd.tmc.am.common.helper.IfmSettleCenterHelper;
import kd.tmc.am.common.resource.AmBizResource;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.enums.TmcParamEnum;

public class BankAcctOpenSubmitValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        AmBizResource amBizResource = new AmBizResource();
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            Long pkValue;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObject company = dataEntity.getDynamicObject("company");
            String isOpenByProcess = AmParameterHelper.getAppStringParameter((long)company.getLong("id"), (String)TmcParamEnum.AM001.getValue());
            if ("0".equals(isOpenByProcess) && !Objects.equals(dataEntity.get("finorgtype"), FinOrgTypeEnum.CLEARINGHOUSE.getValue())) {
                this.addErrorMessage(extendedDataEntity, new AmBizResource().getErrorDirecTopen());
            }
            if (!Objects.equals(dataEntity.getString("finorgtype"), FinOrgTypeEnum.CLEARINGHOUSE.getValue())) continue;
            DynamicObject bank = dataEntity.getDynamicObject("bank");
            if (bank == null) {
                return;
            }
            List settleCenterIds = IfmSettleCenterHelper.getOpenSettleCenterIds();
            if (settleCenterIds.contains(pkValue = (Long)bank.getPkValue())) continue;
            this.addErrorMessage(extendedDataEntity, amBizResource.getCheckSettleCenter());
        }
    }
}

