/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.validate.bankacct;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.am.common.errorcode.BankAcctErrorCode;
import kd.tmc.am.common.exception.AmException;
import kd.tmc.am.common.helper.AmParameterHelper;
import kd.tmc.am.common.helper.BankAcctHelper;
import kd.tmc.am.common.resource.AmBizResource;
import kd.tmc.am.common.resource.BankAcctBizResource;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.TmcParamEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class BankAcctPreCloseValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        super.getSelector();
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("company");
        sic.add("finorgtype");
        sic.add("acctstatus");
        sic.add("bank");
        sic.add("bankaccountnumber");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        if (null != dataEntity && dataEntity.length > 1) {
            throw new AmException(new BankAcctErrorCode().BATCH_OP_ERROR());
        }
        AmBizResource amBizResource = new AmBizResource();
        for (ExtendedDataEntity data : this.dataEntities) {
            String createOrg;
            QFilter[] filters;
            DynamicObject closeBill;
            DynamicObject company;
            boolean isCloseAcctByProcess;
            DynamicObject bankAcct = data.getDataEntity();
            String acctStatus = bankAcct.getString("acctstatus");
            if (!acctStatus.equals(BankAcctStatusEnum.NORMAL.getValue())) {
                this.addErrorMessage(data, String.format(amBizResource.getUncloseacctStatuserror(), BankAcctStatusEnum.getName((String)acctStatus)));
            }
            if ((isCloseAcctByProcess = AmParameterHelper.getAppBoolParameter((long)((Long)(company = bankAcct.getDynamicObject("company")).getPkValue()), (String)TmcParamEnum.AM002.getValue())) && null != (closeBill = BusinessDataServiceHelper.loadSingleFromCache((String)"am_acctclosebill", (QFilter[])(filters = new QFilter[]{new QFilter("accountbank", "=", bankAcct.getPkValue()), new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue())})))) {
                this.addErrorMessage(data, amBizResource.getCloseacctExistbill());
            }
            if (!StringUtils.isEmpty((CharSequence)(createOrg = this.getOption().getVariableValue("createorg"))) && !Objects.equals(createOrg, String.valueOf(company.getPkValue()))) {
                this.addErrorMessage(data, amBizResource.getUnAllowCloseAssign());
            }
            HashSet<String> billStatus = new HashSet<String>(2);
            billStatus.add(BillStatusEnum.AUDIT.getValue());
            billStatus.add("E");
            QFilter acctCloseFilter = new QFilter("billstatus", "not in", billStatus);
            acctCloseFilter.and(new QFilter("accountbank", "=", bankAcct.getPkValue()));
            boolean isExistAcctCloseBill = TmcDataServiceHelper.exists((String)"am_acctclosebill", (QFilter[])new QFilter[]{acctCloseFilter});
            if (isExistAcctCloseBill) {
                this.addErrorMessage(data, new BankAcctBizResource().getExistAcctCloseBill(bankAcct.getString("bankaccountnumber")));
            }
            QFilter acctChangeApplyFilter = new QFilter("billstatus", "not in", billStatus);
            acctChangeApplyFilter.and(new QFilter("entryentity2.e_accountbank", "=", bankAcct.getPkValue()));
            boolean isExitsChangeApplyBill = QueryServiceHelper.exists((String)"am_changeapply", (QFilter[])new QFilter[]{acctChangeApplyFilter});
            if (isExitsChangeApplyBill) {
                this.addErrorMessage(data, new BankAcctBizResource().getExistChangeApplyBill(bankAcct.getString("bankaccountnumber")));
            }
            if (!BankAcctHelper.existUnAuditAccountManageTransfer((Object)bankAcct.getPkValue())) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"{0}\u94f6\u884c\u8d26\u6237\u7ba1\u7406\u6743\u8f6c\u8ba9\u4e2d\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u9500\u6237\u3002", (String)"BankAcctPreCloseValidator_01", (String)"tmc-am-business", (Object[])new Object[]{bankAcct.getString("bankaccountnumber")}));
        }
    }
}

