/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.validate.bankacct;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.am.common.errorcode.BankAcctErrorCode;
import kd.tmc.am.common.exception.AmException;
import kd.tmc.am.common.helper.AccountBankHelper;
import kd.tmc.am.common.helper.AmParameterHelper;
import kd.tmc.am.common.helper.BankAcctHelper;
import kd.tmc.am.common.resource.AmBizResource;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.TmcParamEnum;

public class BankAcctUnCloseValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        super.getSelector();
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("company");
        sic.add("acctstatus");
        sic.add("acctstyle");
        sic.add("inneracct");
        sic.add("openorg");
        sic.add("iselecpayment");
        sic.add("relatedsettleacct");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        if (null != dataEntity && dataEntity.length > 1) {
            throw new AmException(new BankAcctErrorCode().BATCH_OP_ERROR());
        }
        AmBizResource amBizResource = new AmBizResource();
        for (ExtendedDataEntity data : this.dataEntities) {
            long companyId;
            boolean isCheckOneBasic;
            String acctStyle;
            DynamicObject closeDetail = data.getDataEntity();
            boolean elecPayment = closeDetail.getBoolean("iselecpayment");
            if (elecPayment) {
                Set acctSet = AccountBankHelper.getElecPaymentRelatedAcctIds((Long)closeDetail.getLong("id"));
                Set relatedSettleAcct = closeDetail.getDynamicObjectCollection("relatedsettleacct").stream().map(acct -> acct.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                for (Long id : relatedSettleAcct) {
                    if (!acctSet.contains(id)) continue;
                    DynamicObject settleAcct = QueryServiceHelper.queryOne((String)"am_accountbank", (String)"bankaccountnumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
                    this.addErrorMessage(data, amBizResource.getExistElecPaymentAcctUnClose(settleAcct.getString("bankaccountnumber")));
                }
            }
            DynamicObject company = closeDetail.getDynamicObject("company");
            if (BankAcctHelper.isInnerAcct((DynamicObject)closeDetail)) {
                this.addErrorMessage(data, amBizResource.getInnerAcctForbidUnClose());
                continue;
            }
            boolean isCloseAcctByProcess = AmParameterHelper.getAppBoolParameter((long)company.getLong("id"), (String)TmcParamEnum.AM002.getValue());
            if (isCloseAcctByProcess) {
                this.addErrorMessage(data, amBizResource.getUncloseOrgError());
            }
            if (!"basic".equalsIgnoreCase(acctStyle = closeDetail.getString("acctstyle")) || company == null || !(isCheckOneBasic = AmParameterHelper.getAppBoolParameter((long)(companyId = company.getLong("id")), (String)"ischeckonebasic"))) continue;
            QFilter qFilter = new QFilter("acctstatus", "=", (Object)"normal");
            qFilter.and("company", "=", (Object)companyId);
            qFilter.and("acctstyle", "=", (Object)"basic");
            qFilter.and("id", "!=", closeDetail.getPkValue());
            DynamicObjectCollection resultDt = QueryServiceHelper.query((String)"am_accountbank", (String)"id", (QFilter[])qFilter.toArray(), null);
            if (resultDt.size() <= 0) continue;
            this.addErrorMessage(data, amBizResource.getExistBasicAcctUnClose());
        }
    }
}

