/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.validate.bankacct;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.am.common.enums.AcctClassifyEnum;
import kd.tmc.am.common.helper.AmParameterHelper;
import kd.tmc.am.common.resource.AmBizResource;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankAcctUnFreezeValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("acctstatus");
        selector.add("acctclassify");
        selector.add("createorg");
        selector.add("company");
        selector.add("acctstyle");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        AmBizResource resource = new AmBizResource();
        String createOrg = this.getOption().getVariableValue("createOrg");
        ExtendedDataEntity[] bankAcctEntities = this.getDataEntities();
        Map<Object, List<DynamicObject>> companyBasicMap = Arrays.stream(bankAcctEntities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.groupingBy(o -> o.getDynamicObject("company").getPkValue()));
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            String acctStatus;
            DynamicObject bankAcct = extendedDataEntity.getDataEntity();
            if (!EmptyUtil.isEmpty((String)createOrg) && !createOrg.equals(bankAcct.getDynamicObject("createorg").getString("id"))) {
                this.addErrorMessage(extendedDataEntity, resource.getUnAllowUnFreezeAssign());
            }
            if (!(acctStatus = bankAcct.getString("acctstatus")).equals(BankAcctStatusEnum.FREEZE.getValue())) {
                this.addErrorMessage(extendedDataEntity, String.format(resource.getUnFreezeAcctStatusError(), BankAcctStatusEnum.getName((String)acctStatus)));
            }
            if (Objects.equals(bankAcct.get("acctclassify"), AcctClassifyEnum.INNER_ACCOUNT.getValue())) {
                this.addErrorMessage(extendedDataEntity, resource.getUnAllowUnFreeze());
            }
            DynamicObject company = bankAcct.getDynamicObject("company");
            String acctStyle = bankAcct.getString("acctstyle");
            if (!"basic".equalsIgnoreCase(acctStyle) || company == null) continue;
            long companyId = company.getLong("id");
            boolean isCheckOneBasic = AmParameterHelper.getAppBoolParameter((long)company.getLong("id"), (String)"ischeckonebasic");
            if (!isCheckOneBasic) continue;
            QFilter qFilter = new QFilter("acctstatus", "=", (Object)"normal");
            qFilter.and("company", "=", (Object)companyId);
            qFilter.and("acctstyle", "=", (Object)"basic");
            qFilter.and("id", "!=", bankAcct.getPkValue());
            DynamicObjectCollection resultDt = QueryServiceHelper.query((String)"am_accountbank", (String)"id", (QFilter[])qFilter.toArray(), null);
            if (resultDt.size() <= 0) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8be5\u7533\u8bf7\u516c\u53f8\u5df2\u7ecf\u5b58\u5728\u57fa\u672c\u6237\uff0c\u4e0d\u80fd\u89e3\u51bb\u3002", (String)"BankAcctUnFreezeValidator_1", (String)"tmc-am-business", (Object[])new Object[0]));
        }
    }
}

