/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.validate.bankacct;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.am.common.helper.BankAcctManageHelp;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;

public class BankManagePermChangeValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("company");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        List ids = Arrays.stream(dataEntity).map(extendedDataEntity -> extendedDataEntity.getDataEntity().get("id")).collect(Collectors.toList());
        DynamicObject[] bankAccountsFromDB = BusinessDataServiceHelper.load((String)"am_accountbank", (String)"company", (QFilter[])new QFilter("id", "in", ids).toArray());
        List<DynamicObject> dynamicObjects = Arrays.stream(dataEntity).map(extendedDataEntity -> extendedDataEntity.getDataEntity()).collect(Collectors.toList());
        List<Long> changeCompanyIds = this.filterChangeCompany(dynamicObjects.toArray(new DynamicObject[0]), bankAccountsFromDB);
        Map returnMap = new HashMap(8);
        if (!CollectionUtils.isEmpty(changeCompanyIds)) {
            returnMap = BankAcctManageHelp.changeManegeCheck(changeCompanyIds, (DynamicObject)((DynamicObject)dynamicObjects.get(0)).getDynamicObject("company"));
        }
        if (returnMap == null || returnMap.size() == 0) {
            return;
        }
        for (ExtendedDataEntity extendedDataEntity2 : this.dataEntities) {
            DynamicObject bankAcct = extendedDataEntity2.getDataEntity();
            if (!returnMap.containsKey(bankAcct.getLong("id"))) continue;
            this.addErrorMessage(extendedDataEntity2, (String)returnMap.get(bankAcct.getLong("id")));
        }
    }

    private List<Long> filterChangeCompany(DynamicObject[] dynamicObjects, DynamicObject[] bankAccountsFromDB) {
        ArrayList<Long> ids = new ArrayList<Long>();
        HashMap<Long, Long> companyMap = new HashMap<Long, Long>(bankAccountsFromDB.length);
        for (DynamicObject bankAccountFromDB : bankAccountsFromDB) {
            companyMap.put((Long)bankAccountFromDB.getPkValue(), (Long)bankAccountFromDB.getDynamicObject("company").getPkValue());
        }
        for (DynamicObject bankAcct : dynamicObjects) {
            Long companyId = (Long)companyMap.get((Long)bankAcct.getPkValue());
            if (Objects.equals(companyId, bankAcct.getDynamicObject("company").getPkValue())) continue;
            ids.add((Long)bankAcct.getPkValue());
        }
        return ids;
    }
}

