/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.validate.bankacct.management;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.am.common.errorcode.BankAcctErrorCode;
import kd.tmc.am.common.exception.AmException;
import kd.tmc.am.common.helper.BankAcctHelper;
import kd.tmc.am.common.resource.BankAcctBizResource;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class BankAcctManageTransferValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        super.getSelector();
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("acctstatus");
        sic.add("company");
        sic.add("bankaccountnumber");
        sic.add("ctrlstrategy");
        sic.add("createorg");
        sic.add("bank");
        sic.add("finorgtype");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        if (null != dataEntity && dataEntity.length > 1) {
            throw new AmException(new BankAcctErrorCode().BATCH_OP_ERROR());
        }
        for (ExtendedDataEntity data : this.dataEntities) {
            String ctrlStrategy;
            DynamicObject bankAcct = data.getDataEntity();
            String acctStatus = bankAcct.getString("acctstatus");
            if (!StringUtils.equals((CharSequence)acctStatus, (CharSequence)BankAcctStatusEnum.NORMAL.getValue())) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u53ea\u6709\u6b63\u5e38\u72b6\u6001\u7684\u94f6\u884c\u8d26\u6237\u624d\u5141\u8bb8\u7ba1\u7406\u6743\u8f6c\u8ba9\u3002", (String)"BankAcctManageTransferValidator_01", (String)"tmc-am-business", (Object[])new Object[0]));
            }
            if (BankAcctHelper.existUnAuditAccountManageTransfer((Object)bankAcct.getPkValue())) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\u7ba1\u7406\u6743\u8f6c\u8ba9\u4e2d\u3002", (String)"BankAcctManageTransferValidator_03", (String)"tmc-am-business", (Object[])new Object[0]));
            }
            if (StringUtils.equals((CharSequence)(ctrlStrategy = bankAcct.getString("ctrlstrategy")), (CharSequence)"7")) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u63a7\u5236\u7b56\u7565\u4e3a\u79c1\u6709\u7684\u94f6\u884c\u8d26\u6237\u4e0d\u5141\u8bb8\u8f6c\u8ba9\u7ba1\u7406\u6743\u3002", (String)"BankAcctManageTransferValidator_04", (String)"tmc-am-business", (Object[])new Object[0]));
            }
            DynamicObject acctCreateOrg = bankAcct.getDynamicObject("createorg");
            String createOrg = this.getOption().getVariableValue("createorg");
            if (!StringUtils.isEmpty((CharSequence)createOrg) && Long.parseLong(createOrg) != acctCreateOrg.getLong("id")) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u53ea\u6709\u521b\u5efa\u7ec4\u7ec7\u624d\u80fd\u8fdb\u884c\u7ba1\u7406\u6743\u8f6c\u8ba9\u3002", (String)"BankAcctManageTransferValidator_02", (String)"tmc-am-business", (Object[])new Object[]{acctCreateOrg.getString("name")}));
            }
            if (FinOrgTypeEnum.CLEARINGHOUSE.getValue().equals(bankAcct.getString("finorgtype"))) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3\u8d26\u6237\u4e0d\u5141\u8bb8\u64cd\u4f5c\u7ba1\u7406\u6743\u8f6c\u8ba9\u3002", (String)"BankAcctManageTransferValidator_05", (String)"tmc-am-business", (Object[])new Object[]{acctCreateOrg.getString("name")}));
            }
            QFilter acctCloseFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
            acctCloseFilter.and(new QFilter("accountbank", "=", bankAcct.getPkValue()));
            boolean isExistAcctCloseBill = TmcDataServiceHelper.exists((String)"am_acctclosebill", (QFilter[])new QFilter[]{acctCloseFilter});
            if (isExistAcctCloseBill) {
                this.addErrorMessage(data, new BankAcctBizResource().getExistAcctCloseBill(bankAcct.getString("bankaccountnumber")));
            }
            QFilter acctChangeApplyFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
            acctChangeApplyFilter.and(new QFilter("entryentity2.e_accountbank", "=", bankAcct.getPkValue()));
            boolean isExitsChangeApplyBill = TmcDataServiceHelper.exists((String)"am_changeapply", (QFilter[])new QFilter[]{acctChangeApplyFilter});
            if (!isExitsChangeApplyBill) continue;
            this.addErrorMessage(data, new BankAcctBizResource().getExistChangeApplyBill(bankAcct.getString("bankaccountnumber")));
        }
    }
}

