/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.validate.changeapply;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.am.common.helper.AccountBankHelper;
import kd.tmc.am.common.helper.AmHelper;
import kd.tmc.am.common.resource.AmBizResource;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.VisibleVirtualAcctHelper;

public class ChangeApplyAuditValidate
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        super.getSelector();
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("accountbank");
        sic.add("applydate");
        sic.add("applyuser");
        sic.add("entryentity.relatedsettleacct");
        return sic;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : extendedDataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            DynamicObjectCollection entryEntity = data.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection accountEntryEntities = data.getDynamicObjectCollection("entryentity2");
            Object[] bankAcctIds = accountEntryEntities.stream().map(o -> o.getDynamicObject("e_accountbank").getPkValue()).toArray();
            DynamicObject[] bankAccounts = TmcDataServiceHelper.load((Object[])bankAcctIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"am_accountbank"));
            Map<Object, DynamicObject> bankAcctMap = Arrays.stream(bankAccounts).collect(Collectors.toMap(DataEntityBase::getPkValue, v -> v));
            for (DynamicObject accountEntryEntity : accountEntryEntities) {
                DynamicObject bankAcct = bankAcctMap.get(accountEntryEntity.getDynamicObject("e_accountbank").getPkValue());
                boolean isVirtual = bankAcct.getBoolean("isvirtual");
                for (DynamicObject entry : entryEntity) {
                    String changeFieldName = entry.getString("e_changefield");
                    if ("bank".equalsIgnoreCase(changeFieldName)) {
                        Long id;
                        DynamicObject changeFieldValue = (DynamicObject)entry.get("e_basedata");
                        Object[] bankIds = new Object[]{changeFieldValue.getPkValue()};
                        DynamicObject[] banks = TmcDataServiceHelper.load((Object[])bankIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_finorginfo"));
                        if (banks == null || banks.length <= 0) continue;
                        DynamicObject bankObj = banks[0];
                        DynamicObject bankCate = bankObj.getDynamicObject("bank_cate");
                        boolean newBankIsVirtual = false;
                        if (AmHelper.isNotEmpty((Object)bankCate) && AmHelper.isNotEmpty((Object)(id = (Long)bankCate.getPkValue())) && Boolean.TRUE.equals(VisibleVirtualAcctHelper.checkVirtualAcct((Long)id))) {
                            newBankIsVirtual = true;
                        }
                        if (newBankIsVirtual == isVirtual) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u865a\u62df\u8d26\u6237\u548c\u771f\u5b9e\u8d26\u6237\u4e0d\u80fd\u4e92\u76f8\u53d8\u66f4\u3002", (String)"BankAccountChangeValidator_4", (String)"tmc-am-business", (Object[])new Object[0]));
                        continue;
                    }
                    if (!"relatedsettleacct".equals(changeFieldName)) continue;
                    Set acctSet = AccountBankHelper.getElecPaymentRelatedAcctIds((Long)bankAcct.getLong("id"));
                    Set relatedSettleAcct = entry.getDynamicObjectCollection("e_relatedsettleacct").stream().map(acct -> acct.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                    AmBizResource amBizResource = new AmBizResource();
                    for (Long id : relatedSettleAcct) {
                        if (!acctSet.contains(id)) continue;
                        DynamicObject settleAcct = QueryServiceHelper.queryOne((String)"am_accountbank", (String)"bankaccountnumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
                        this.addErrorMessage(dataEntity, amBizResource.getExistElecPaymentAcctUnClose(settleAcct.getString("bankaccountnumber")));
                    }
                }
            }
        }
    }
}

