/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.validate.changeapply;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.am.common.helper.BankAcctHelper;
import kd.tmc.am.common.resource.BankAcctBizResource;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ChangeApplySubmitValidate
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        super.getSelector();
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("e_accountbank");
        sic.add("applydate");
        sic.add("applyuser");
        sic.add("entryentity");
        sic.add("entryentity.e_changefield");
        sic.add("entryentity.e_basedata");
        sic.add("netbankgrantentity");
        sic.add("entrysignetentity");
        sic.add("feedetail");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            DynamicObjectCollection entryEntity = data.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection netBankGrantEntity = data.getDynamicObjectCollection("netbankgrantentity");
            DynamicObjectCollection entrySignetEntity = data.getDynamicObjectCollection("entrysignetentity");
            DynamicObjectCollection feeDetail = data.getDynamicObjectCollection("feedetail");
            if (entryEntity.size() == 0 && EmptyUtil.isEmpty((DynamicObjectCollection)netBankGrantEntity) && EmptyUtil.isEmpty((DynamicObjectCollection)entrySignetEntity) && EmptyUtil.isEmpty((DynamicObjectCollection)feeDetail)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u5f55\u5165\u4e00\u9879\u9700\u8981\u53d8\u66f4\u7684\u5185\u5bb9\u3002", (String)"ChangeApplySubmitValidate_0", (String)"tmc-am-business", (Object[])new Object[0]));
            }
            boolean changeProxyAcct = Boolean.FALSE;
            boolean changeProxyCurrency = Boolean.FALSE;
            boolean proxyAcctHasValue = Boolean.FALSE;
            boolean proxyCurrencyHasValue = Boolean.FALSE;
            boolean allProxyAcctHasValue = Boolean.TRUE;
            boolean allProxyCurrencyHasValue = Boolean.TRUE;
            boolean containsProxyInquiry = Boolean.TRUE;
            boolean changeValueContainsPi = Boolean.FALSE;
            HashSet<String> bankInterFaceSet = new HashSet<String>(2);
            boolean interFaceChanged = Boolean.FALSE;
            boolean additionalPropertyChanged = Boolean.FALSE;
            DynamicObjectCollection accountEntryEntities = data.getDynamicObjectCollection("entryentity2");
            for (DynamicObject accountEntryEntity : accountEntryEntities) {
                String proxyProxyAcct;
                DynamicObject proxyCurrency;
                DynamicObject bankAcct = accountEntryEntity.getDynamicObject("e_accountbank");
                if (!EmptyUtil.isNoEmpty((DynamicObject)bankAcct)) continue;
                bankInterFaceSet.add(bankAcct.getString("bankinterface"));
                for (DynamicObject entryColl : entryEntity) {
                    DynamicObject company;
                    if (!"company".equals(entryColl.getString("e_changefield")) || (company = entryColl.getDynamicObject("e_basedata")) == null || !BankAcctHelper.isRefrenced((Object)bankAcct.getPkValue())) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u94f6\u884c\u8d26\u6237\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u80fd\u66f4\u6539\u7533\u8bf7\u516c\u53f8", (String)"ChangeApplySubmitValidate_1", (String)"tmc-am-business", (Object[])new Object[0]));
                }
                String beBankFunc = bankAcct.getString("bebankfunc");
                if (!beBankFunc.contains("proxyinquiry") && containsProxyInquiry) {
                    containsProxyInquiry = Boolean.FALSE;
                }
                if (EmptyUtil.isEmpty((DynamicObject)(proxyCurrency = bankAcct.getDynamicObject("proxycurrency"))) && allProxyCurrencyHasValue) {
                    allProxyCurrencyHasValue = Boolean.FALSE;
                }
                if (!EmptyUtil.isEmpty((String)(proxyProxyAcct = bankAcct.getString("proxyinquiryaccount"))) || !allProxyAcctHasValue) continue;
                allProxyAcctHasValue = Boolean.FALSE;
            }
            for (DynamicObject entryColl : entryEntity) {
                String changeFiled = entryColl.getString("e_changefield");
                switch (changeFiled) {
                    case "bankinterface": {
                        interFaceChanged = Boolean.TRUE;
                        break;
                    }
                    case "additionalproperty": {
                        additionalPropertyChanged = Boolean.TRUE;
                        break;
                    }
                    case "proxycurrency": {
                        changeProxyCurrency = Boolean.TRUE;
                        DynamicObject proxyCurrency = entryColl.getDynamicObject("e_basedata");
                        if (!EmptyUtil.isNoEmpty((DynamicObject)proxyCurrency)) break;
                        proxyCurrencyHasValue = Boolean.TRUE;
                        break;
                    }
                    case "proxyinquiryaccount": {
                        changeProxyAcct = Boolean.TRUE;
                        String afterChangeValue = entryColl.getString("e_afterchange");
                        if (!EmptyUtil.isNoEmpty((String)afterChangeValue)) break;
                        proxyAcctHasValue = Boolean.TRUE;
                        break;
                    }
                    case "bebankfunc": {
                        String changeValue = entryColl.getString("e_afterchange");
                        if (!changeValue.contains("proxyinquiry")) break;
                        changeValueContainsPi = Boolean.TRUE;
                        break;
                    }
                }
            }
            if (bankInterFaceSet.size() > 1 && !interFaceChanged && additionalPropertyChanged) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d26\u6237\u7684\u94f6\u4f01\u63a5\u53e3\u76f8\u540c\u624d\u80fd\u53d8\u66f4\u63a5\u53e3\u7684\u9644\u52a0\u5c5e\u6027\u3002", (String)"ChangeApplySubmitValidate_2", (String)"tmc-am-business", (Object[])new Object[0]));
            }
            if (!containsProxyInquiry && !changeValueContainsPi && (changeProxyAcct || changeProxyCurrency)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d26\u6237\u7684\u3010\u94f6\u4f01\u529f\u80fd\u3011\u542b\u6709\u3010\u4ee3\u7406\u67e5\u8be2\u3011\u65f6\u624d\u80fd\u53d8\u66f4\u3010\u4ee3\u7406\u67e5\u8be2\u5e01\u79cd\u3011\u6216\u8005\u3010\u4ee3\u7406\u67e5\u8be2\u8d26\u6237\u3011\u3002", (String)"ChangeApplySubmitValidate_5", (String)"tmc-am-business", (Object[])new Object[0]));
            }
            if (changeProxyAcct && changeProxyCurrency) {
                if (proxyCurrencyHasValue == proxyAcctHasValue) continue;
                BankAcctBizResource resource = new BankAcctBizResource();
                this.addErrorMessage(dataEntity, resource.getProxyAccountValidator());
                continue;
            }
            if (changeProxyAcct) {
                if (!(proxyAcctHasValue ^ allProxyCurrencyHasValue)) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53d8\u66f4\u3010\u4ee3\u7406\u67e5\u8be2\u8d26\u6237\u3011\u65f6\uff0c\u6240\u6709\u9700\u53d8\u66f4\u8d26\u53f7\u7684\u3010\u4ee3\u7406\u67e5\u8be2\u5e01\u79cd\u3011\u540c\u65f6\u6709\u503c\u6216\u8005\u4e3a\u7a7a\u3002", (String)"ChangeApplySubmitValidate_3", (String)"tmc-am-business", (Object[])new Object[0]));
                continue;
            }
            if (!changeProxyCurrency || !(proxyCurrencyHasValue ^ allProxyAcctHasValue)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53d8\u66f4\u3010\u4ee3\u7406\u67e5\u8be2\u5e01\u79cd\u3011\u65f6\uff0c\u6240\u6709\u9700\u53d8\u66f4\u8d26\u53f7\u7684\u3010\u4ee3\u7406\u67e5\u8be2\u8d26\u6237\u3011\u540c\u65f6\u6709\u503c\u6216\u8005\u4e3a\u7a7a\u3002", (String)"ChangeApplySubmitValidate_4", (String)"tmc-am-business", (Object[])new Object[0]));
        }
    }
}

