/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.validate.changeapply;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ChangeApplyUnSubmitValidate
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        super.getSelector();
        ArrayList<String> sic = new ArrayList<String>(0);
        sic.add(String.join((CharSequence)".", "entryentity2", "e_accountbank"));
        sic.add(String.join((CharSequence)".", "e_accountbank", "finorgtype"));
        sic.add(String.join((CharSequence)".", "e_accountbank", "bankaccountnumber"));
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        HashSet<String> bankAccountNumberSet = new HashSet<String>(10);
        HashMap<String, ExtendedDataEntity> dataEntityMap = new HashMap<String, ExtendedDataEntity>(10);
        for (ExtendedDataEntity data : dataEntity) {
            DynamicObject dyObj = data.getDataEntity();
            DynamicObjectCollection acctEntries = dyObj.getDynamicObjectCollection("entryentity2");
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)acctEntries)) continue;
            for (DynamicObject entry : acctEntries) {
                String bankAccountNumber;
                DynamicObject accountBank = entry.getDynamicObject("e_accountbank");
                if (!EmptyUtil.isNoEmpty((DynamicObject)accountBank)) continue;
                String finOrgType = accountBank.getString("finorgtype");
                if (!FinOrgTypeEnum.CLEARINGHOUSE.getValue().equals(finOrgType) || !EmptyUtil.isNoEmpty((String)(bankAccountNumber = accountBank.getString("bankaccountnumber")))) continue;
                bankAccountNumberSet.add(bankAccountNumber);
                dataEntityMap.put(bankAccountNumber, data);
            }
        }
        if (EmptyUtil.isNoEmpty(bankAccountNumberSet)) {
            Set ifmAcctBanks;
            QFilter qFilter = new QFilter("bankaccountnumber", "in", bankAccountNumberSet);
            qFilter.and("billstatus", "=", (Object)"B");
            DynamicObjectCollection ifmBills = QueryServiceHelper.query((String)"ifm_accountacceptancebill", (String)"id,bankaccountnumber", (QFilter[])qFilter.toArray());
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)ifmBills) && EmptyUtil.isNoEmpty(ifmAcctBanks = ifmBills.stream().map(o -> o.getString("bankaccountnumber")).collect(Collectors.toSet()))) {
                for (String acctNumber : ifmAcctBanks) {
                    ExtendedDataEntity data = (ExtendedDataEntity)dataEntityMap.get(acctNumber);
                    if (!EmptyUtil.isNoEmpty((Object)data)) continue;
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e0b\u6e38\u5185\u90e8\u91d1\u878d\u5355\u636e\u4e0d\u4e3a\u201c\u6682\u5b58\u201d\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u64a4\u9500\u3002", (String)"BankAcctOpenUnSubmitValidator_1", (String)"tmc-am-business", (Object[])new Object[0]));
                }
            }
        }
    }
}

