/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.validate.closeacct;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.am.common.resource.AmBizResource;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;

public class BankAcctCloseSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        super.getSelector();
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("accountbank");
        sic.add("billstatus");
        sic.add("closedate");
        sic.add("acctstatus");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        AmBizResource amBizResource = new AmBizResource();
        for (ExtendedDataEntity data : this.dataEntities) {
            QFilter[] filters;
            DynamicObject closeBill;
            Object closeDate;
            DynamicObject bankAcctCloseBill = data.getDataEntity();
            String billStatus = bankAcctCloseBill.getString("billstatus");
            DynamicObject bankAcct = (DynamicObject)bankAcctCloseBill.get("accountbank");
            if (billStatus.equals(BillStatusEnum.HANDLE.getValue()) && null == (closeDate = bankAcctCloseBill.get("closedate"))) {
                this.addErrorMessage(data, amBizResource.getCloseacctClosedateless());
            }
            String acctStatus = bankAcct.getString("acctstatus");
            if (billStatus.equals(BillStatusEnum.SAVE.getValue()) && !acctStatus.equals(BankAcctStatusEnum.NORMAL.getValue())) {
                this.addErrorMessage(data, String.format(amBizResource.getUncloseacctStatuserror(), BankAcctStatusEnum.getName((String)acctStatus)));
            }
            if (null == (closeBill = BusinessDataServiceHelper.loadSingleFromCache((String)"am_acctclosebill", (QFilter[])(filters = new QFilter[]{new QFilter("accountbank", "=", bankAcct.getPkValue()), new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue()), new QFilter("id", "not in", bankAcctCloseBill.getPkValue())})))) continue;
            this.addErrorMessage(data, amBizResource.getCloseacctExistbill());
        }
    }
}

