/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.validate.closeacct;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.am.common.helper.BankAcctManageHelp;
import kd.tmc.am.common.resource.AmBizResource;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;

public class BankAcctCloseValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        super.getSelector();
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("finorgtype");
        sic.add("currency");
        sic.add("company");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        Map variables = this.getOption().getVariables();
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)variables.get("isneedvalidate")))) {
            return;
        }
        AmBizResource amBizResource = new AmBizResource();
        for (ExtendedDataEntity data : this.dataEntities) {
            List errorMsgList;
            DynamicObject bankAcct = data.getDataEntity();
            long bankAcctId = bankAcct.getLong("id");
            String finorgType = bankAcct.getString("finorgtype");
            if (finorgType.equals(FinOrgTypeEnum.CLEARINGHOUSE.getName()) || finorgType.equals(FinOrgTypeEnum.FINCOMP.getName())) {
                this.addErrorMessage(data, amBizResource.getDeleteAcctError());
            }
            if (bankAcct == null || (errorMsgList = BankAcctManageHelp.bankAcctCloseCheck((DynamicObject)bankAcct)) == null || errorMsgList.size() <= 0) continue;
            for (String errorMsg : errorMsgList) {
                this.addErrorMessage(data, errorMsg);
            }
        }
    }
}

